<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generador de Patente Suave</title>
    <style>
        body {
            background: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        canvas {
            background: white;
            border: 1px solid #ccc;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <canvas id="previewCanvas" width="420" height="280"></canvas>
    <script>
        const canvas = document.getElementById('previewCanvas');
        const ctx = canvas.getContext('2d');
        const text = 'ABC123';  // Aquí puedes integrar el valor dinámico

        // Fondo blanco
        ctx.fillStyle = 'white';
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        // Texto más suave
        ctx.fillStyle = 'rgba(0, 0, 0, 0.4)';
        ctx.font = '400 85px Arial, sans-serif';
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        ctx.fillText(text, canvas.width / 2, canvas.height / 2);

        // Logo (si tuvieras uno)
        const img = new Image();
        img.onload = function() {
            ctx.globalAlpha = 0.5;
            const logoHeight = 80;
            const logoWidth = (img.width * logoHeight) / img.height;
            ctx.drawImage(img, (canvas.width - logoWidth) / 2, 30, logoWidth, logoHeight);
            ctx.globalAlpha = 1;
        };
        img.src = 'logo.png';  // Pon aquí el path a tu logo

        // Descargar en PNG
        function descargarPNG() {
            const link = document.createElement('a');
            link.download = 'patente_suave.png';
            link.href = canvas.toDataURL('image/png');
            link.click();
        }

        // Para descargar después de unos segundos (o conecta a un botón)
        setTimeout(descargarPNG, 1000);
    </script>
</body>
</html>
