<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aplicación Responsiva</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #00c897;
            --secondary-color: #1d2d44;
            --accent-color: #f48c06;
            --text-color: #ffffff;
            --border-radius: 8px;
            --shadow-color: rgba(0, 0, 0, 0.2);
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, #1d2d44 0%, #0a1a30 100%);
            color: var(--text-color);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 2rem;
        }

        .input-group {
            display: flex;
            flex-direction: column;
            gap: 15px;
            align-items: center;
        }

        .input-group input, .input-group select {
            padding: 10px;
            border-radius: var(--border-radius);
            border: none;
            width: 80%;
            max-width: 400px;
        }

        .buttons {
            display: flex;
            justify-content: center;
            gap: 10px;
        }

        .buttons button {
            padding: 10px 20px;
            border-radius: var(--border-radius);
            border: none;
            background: var(--primary-color);
            color: var(--text-color);
            cursor: pointer;
            font-size: 1rem;
        }

        .buttons button:hover {
            background: var(--accent-color);
        }

        @media (max-width: 768px) {
            .header h1 {
                font-size: 1.5rem;
            }

            .input-group input, .input-group select {
                width: 100%;
            }
        }

        @media (max-width: 480px) {
            .header h1 {
                font-size: 1.2rem;
            }

            .buttons button {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
   <!-- <div class="container">
        <div class="header">
            <h1>Aplicación Responsiva</h1>
        </div>
        
        </div>
    </div>-->
    

						                    <label>Cargar logo:</label>
						                    <div class="file-input-wrapper" bis_skin_checked="1">
						                        <input type="file" id="logoInput" accept="image/*">
						                    </div>
						                </div>
						                <div bis_skin_checked="1">
						                    <label>Logos:</label>
						                    <select id="jpgLogoSelect" onchange="handleJpgLogoSelect()">
						                        <option value="">Seleccionar</option>
						                        <option value="ALFA ROMEO.jpg">ALFA ROMEO</option>
						                        <option value="Audi.jpg">Audi</option>
						                        <option value="Audi2.jpg">Audi2</option>
						                        <option value="Baic group.jpg">Baic Group</option>                     
						                        <option value="BMW.jpg">BMW</option>
						                        <option value="Byd.jpg">Byd</option>
						                        <option value="brilliance.jpg">Brilliance</option>                  
						                        <option value="Changan.jpg">Changan</option>
						                        <option value="chery.jpg">Chery</option>
						                        <option value="Cherry.jpg">Cherry</option>                       
						                        <option value="Chevrolet.jpg">Chevrolet</option>
						                        <option value="Citroen.jpg">Citroen</option>
						                        <option value="Daewoo.jpg">Daewoo</option>
						                        <option value="Dfsk.jpg">Dfsk</option>                       
						                        <option value="Donge.jpg">Donge</option>
						                        <option value="dongfeng.jpg">dongfeng</option>                     
						                        <option value="Faw.jpg">Faw</option>                   
						                        <option value="FIAT2.jpg">FIAT1</option>
						                        <option value="FIAT.jpg">FIAT2</option>
						                        <option value="Ford.jpg">Ford</option>
						                        <option value="foton.jpg">Foton.jpg</option>
						                        <option value="Geely.jpg">Geely</option>
						                        <option value="Great Wall.jpg">Great Wall</option>
						                        <option value="Honda.jpg">Honda</option>
						                        <option value="honda2.jpg">honda2</option>
						                        <option value="Hyundai Motor.jpg">Hyundai Motor</option>
						                        <option value="Hyundai.jpg">Hyundai</option>
						                        <option value="isuzu.jpg">Isuzu</option>
						                        <option value="JAC motor.jpg">JAC motor</option>
						                        <option value="Jaguar.jpg">Jaguar</option>
						                        <option value="Jeep.jpg">Jeep</option>
						                        <option value="JMC1.jpg">JMC1</option>
						                        <option value="KIA1.jpg">KIA1</option>
						                        <option value="KIA2.jpg">KIA2</option>
						                        <option value="Land Rover.jpg">Land Rover</option>
						                        <option value="Lexus.jpg">Lexus</option>
						                        <option value="Lexus2.jpg">Lexus2</option>
						                        <option value="lifan.jpg">Lifan</option>
						                        <option value="maxus.jpeg">Maxus</option>
						                        <option value="mahindra.jpg">Mahindra</option>
						                        <option value="Mazda.jpg">Mazda</option>
						                        <option value="Mercedes Benz.jpg">Mercedes Benz</option>
						                        <option value="MG.jpg">MG</option>
						                        <option value="Mini.jpg">Mini</option>
						                        <option value="Mitsubishi.jpg">Mitsubishi</option>
						                        <option value="Nissan.jpg">Nissan</option>
						                        <option value="NISSAN2.jpg">NISSAN2</option>
						                        <option value="Peugeot.jpg">Peugeot</option>
						                        <option value="Porsche.jpg">Porsche</option>
						                        <option value="Porsche2.jpg">Porsche2</option>
						                        <option value="Renault.jpg">Renault</option>
						                        <option value="Renault2.jpg">Renault2</option>
						                        <option value="Scania.jpg">Scania</option>
						                        <option value="Scania2.jpg">Scania2</option>
						                        <option value="Seat.jpg">Seat</option>
						                        <option value="SEAT2.jpg">SEAT2</option>
						                        <option value="Skoda.jpg">Skoda</option>
						                        <option value="SsangYong.jpg">SsangYong</option>
						                        <option value="SsangYong2.jpg">SsangYong2</option>
						                        <option value="Subaru.jpg">Subaru</option>
						                        <option value="Subaru2.jpg">Subaru2</option>
						                        <option value="Suzuki.jpg">Suzuki</option>
						                        <option value="Suzuki2.jpg">Suzuki2</option>
						                        <option value="TESLA.jpg">TESLA</option>
						                        <option value="Toyota.jpg">Toyota</option>
						                        <option value="Opel.jpg">Opel</option>
						                        <option value="Volkswagen.jpg">Volkswagen</option>
						                        <option value="Volkswagen2.jpg">Volkswagen2</option>
						                        <option value="Volvo.jpg">Volvo</option>
						                        <option value="Volvo2.jpg">Volvo2</option>                                                                                                                       
						                    </select>
						                </div>
						            </div>
						        </div>
						        
						        <div class="input-group" bis_skin_checked="1">
						            <div class="new-patent-input" bis_skin_checked="1">
						                <label for="textInput">Patente:</label>
						                <input type="text" style="text-transform: uppercase" id="textInput" placeholder="6 caracteres" maxlength="6">
						            </div>
						            <div class="mode-buttons" bis_skin_checked="1">
						                <button class="mode-button active" data-mode="280" onclick="selectMode(&#39;280&#39;)">Logos</button>
						                <button class="mode-button" data-mode="200" onclick="selectMode(&#39;200&#39;)">Letras</button>
						                <button class="mode-button" data-mode="auto" onclick="selectMode(&#39;auto&#39;)">Ecomi</button>
						            </div>
						            <div class="format-controls" bis_skin_checked="1">
						                <button class="toggle-button" id="formatToggle" onclick="toggleFormat()">Formato: OFF</button>
						                <select id="formatTypeSelect" onchange="saveSettings(); updateCanvas()" style="display: none;">
						                    <option value="1">AB-CD-EF</option>
						                    <option value="2">AB·CD·EF</option>
						                    <option value="3">AB·CD-EF</option>
						                    <option value="4">AB-CD·EF</option>
						                </select>
						            </div>
						        </div>
						        <div class="preview-area" bis_skin_checked="1">
						            <canvas id="previewCanvas" width="420" height="280"></canvas>
						            <div class="font-controls" bis_skin_checked="1">
						                <div bis_skin_checked="1">
						                    <label>Estilos:</label>
						                    <select id="styleSelect" onchange="updateCanvas()">
						                        <option value="normal" selected="">Normal</option>
						                        <option value="bold">Negritas</option>
						                    </select>
						                </div>
						                <div bis_skin_checked="1">
						                    <label>Fuentes:</label>
						                    <select id="fontSelect" onchange="saveSettings(); updateCanvas()">
						                        <option value="Roboto Condensed">Roboto Condensed</option>
						                        <option value="monospace">Monospace</option>
						                        <option value="FE-FONT">FE-FONT</option>
						                        <option value="serif">Serif</option>
						                        <option value="Arial">Arial</option>
						                        <option value="Times">Times</option>
						                        <option value="Poppins">Poppins</option>
						                    </select>
						                </div>
						                <div class="font-size-buttons" bis_skin_checked="1">
						                    <label>Tamaño:</label>
						                    <span id="fontSizeValue">95</span>
						                    <button type="button" onclick="changeFontSize(5)">+</button>
						                    <button type="button" onclick="changeFontSize(-5)">-</button>
						                </div>
						            </div>
						            <div class="controls-container" bis_skin_checked="1">
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="spacingSlider">Espaciado</label>
						                    <input type="range" id="spacingSlider" min="0" max="150" value="50">
						                </div>
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="sizeSlider">Tamaño Logo</label>
						                    <input type="range" id="sizeSlider" min="20" max="100" value="45">
						                </div>
						            </div>
						        </div>
						        
						        <button onclick="imprimirCanvas()">Descargar Patente</button>
						        <!--<button class="history-button" onclick="showPatentHistory()">Ver Registro de Patentes</button>-->
						        <div id="patentHistoryWindow" bis_skin_checked="1">
						            <h2>Registro de Patentes</h2>
						            <ul id="patentList"></ul>
						            <button class="close-button" onclick="closePatentHistory()">Cerrar</button>
						        </div>
						    </div>
						        
						        
						        <h1>Tu IP Actual:</h1>
						   <p id="ip-address">190.45.25.37</p>
						
						   <script>
						       // Función para obtener la IP
						       async function getIP() {
						           try {
						               const response = await fetch('https://api.ipify.org?format=json');
						               if (!response.ok) {
						                   throw new Error('Error en la solicitud: ' + response.status);
						               }
						               const data = await response.json();
						               document.getElementById('ip-address').textContent = data.ip;
						           } catch (error) {
						               document.getElementById('ip-address').textContent = 'Error al obtener la IP';
						               console.error('Detalles del error:', error);
						           }
						       }
						
						       // Ejecutar la función al cargar la página
						       getIP();
						   </script>
						
						</div></div><div id="imPageRow_4" class="imPageRow" bis_skin_checked="1">
						
						</div>
						
						
						
						
						<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

						
						
				
						
						        

<script>
function imprimirSeccion() {
    const contenido = document.getElementById('area-a-imprimir').innerHTML;
    const ventana = window.open('', '', 'height=600,width=800');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write('</head><body>');
    ventana.document.write(contenido);
    ventana.document.write('
<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</body></html>
</script>

<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</body>
</html>








<!DOCTYPE html>
<!-- saved from url=(0042)https://mipatente.cl/app-grabados-1.8-.php -->
<html prefix="og: http://ogp.me/ns#" lang="es-ES" dir="ltr" class="svg canvas video supports no-touchevents fullscreen cssanimations csstransforms csstransforms3d csstransitions k-webkit k-webkit136"><script src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/content/location/location.js" id="eppiocemhmnlbhjplcgkofciiegomcon"></script><script src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/libs/extend-native-history-api.js"></script><script src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/libs/requests.js"></script><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<title>Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile.</title>
		
		<!--[if IE]><meta http-equiv="ImageToolbar" content="False" /><![endif]-->
		<meta name="author" content="MiPatente.cl">
		<meta name="generator" content="Incomedia WebSite X5 Pro 2025.1.4 - www.websitex5.com">
		<meta name="description" content="Con esta aplicación podrás generar tus plantillas para grabar vidrios logos y patentes con marcas de vehículos más usadas en Chile, Facil y rapido ">
		<meta name="keywords" content="Aplicacion para patentes Gratis, sofware para crear plantillas de patentes gratis, Herramienta para crear plantillas de patentes gratis, aplicacion patentes con logos gratis, generador de plantillas de patentes online gratis, diseña patentes con logos, sofware para impresion de patentes, programa para imprimir patentes con logos, programa para generar plantillas con logos de autos gratis, programa para patentes  ">
		<meta property="og:locale" content="es">
		<meta property="og:type" content="website">
		<meta property="og:url" content="https://mipatente.cl/app-grabados-1.8-.php">
		<meta property="og:title" content="Aplicacion online para generar plantillas para grabado de patentes">
		<meta property="og:site_name" content="MiPatente.cl – Pintado y Grabados de Patentes en Chile.">
		<meta property="og:description" content="Con esta aplicación podrás generar tus plantillas para grabar vidrios logos y patentes con marcas de vehículos más usadas en Chile, Facil y rapido ">
		<meta property="og:image" content="https://mipatente.cl/favImage.png">
		<meta property="og:image:type" content="image/png">
		<meta property="og:image:width" content="868">
		<meta property="og:image:height" content="233">
		<meta property="og:image" content="https://mipatente.cl/favImage_small.png">
		<meta property="og:image:type" content="image/png">
		<meta property="og:image:width" content="400">
		<meta property="og:image:height" content="107">
		<meta name="twitter:card" content="summary_large_image">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/reset.css" media="screen,print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/print.css" media="print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/style.css" media="screen,print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom.css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/animate.min.css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(1).css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus.css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(2).css" media="screen, print"><link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/static.css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(3).css" media="screen, print">
		
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus(1).css" media="screen, print">
		<link rel="stylesheet" href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/app-grabados-1.8-.css" media="screen,print">
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.js.descarga"></script><script bis_use="true" type="text/javascript" charset="utf-8" data-bis-config="[&quot;facebook.com/&quot;,&quot;twitter.com/&quot;,&quot;youtube-nocookie.com/embed/&quot;,&quot;//vk.com/&quot;,&quot;//www.vk.com/&quot;,&quot;linkedin.com/&quot;,&quot;//www.linkedin.com/&quot;,&quot;//instagram.com/&quot;,&quot;//www.instagram.com/&quot;,&quot;//www.google.com/recaptcha/api2/&quot;,&quot;//hangouts.google.com/webchat/&quot;,&quot;//www.google.com/calendar/&quot;,&quot;//www.google.com/maps/embed&quot;,&quot;spotify.com/&quot;,&quot;soundcloud.com/&quot;,&quot;//player.vimeo.com/&quot;,&quot;//disqus.com/&quot;,&quot;//tgwidget.com/&quot;,&quot;//js.driftt.com/&quot;,&quot;friends2follow.com&quot;,&quot;/widget&quot;,&quot;login&quot;,&quot;//video.bigmir.net/&quot;,&quot;blogger.com&quot;,&quot;//smartlock.google.com/&quot;,&quot;//keep.google.com/&quot;,&quot;/web.tolstoycomments.com/&quot;,&quot;moz-extension://&quot;,&quot;chrome-extension://&quot;,&quot;/auth/&quot;,&quot;//analytics.google.com/&quot;,&quot;adclarity.com&quot;,&quot;paddle.com/checkout&quot;,&quot;hcaptcha.com&quot;,&quot;recaptcha.net&quot;,&quot;2captcha.com&quot;,&quot;accounts.google.com&quot;,&quot;www.google.com/shopping/customerreviews&quot;,&quot;buy.tinypass.com&quot;,&quot;gstatic.com&quot;,&quot;secureir.ebaystatic.com&quot;,&quot;docs.google.com&quot;,&quot;contacts.google.com&quot;,&quot;github.com&quot;,&quot;mail.google.com&quot;,&quot;chat.google.com&quot;,&quot;audio.xpleer.com&quot;,&quot;keepa.com&quot;,&quot;static.xx.fbcdn.net&quot;,&quot;sas.selleramp.com&quot;,&quot;1plus1.video&quot;,&quot;console.googletagservices.com&quot;,&quot;//lnkd.demdex.net/&quot;,&quot;//radar.cedexis.com/&quot;,&quot;//li.protechts.net/&quot;,&quot;challenges.cloudflare.com/&quot;,&quot;ogs.google.com&quot;]" src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/executors/traffic.js"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5engine.js.descarga" data-files-version="2025-1-4-0"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main.js.descarga"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.lettering.min.js.descarga"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.textillate.min.js.descarga"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main(1).js.descarga"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus_no16hoiq.js.descarga"></script>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main(2).js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/init.js.descarga"></script>
		
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus.js.descarga"></script>
		<script>
			window.onload = function(){ checkBrowserCompatibility('El Explorador que estás usando no es compatible con las funciones requeridas para mostrar este Sitio web.','El Navegador que estás utilizando podría no ser compatible con las funciones requeridas para poder ver este Sitio web.','[1]Actualiza tu explorador [/1] o [2]continuar de todos modos[/2].','http://outdatedbrowser.com/'); };
			x5engine.utils.currentPagePath = 'app-grabados-1.8-.php';
		</script>
		<link rel="icon" href="https://mipatente.cl/favicon.png?2025-1-4-0-638830202928842429" type="image/png">
		<link rel="alternate" type="application/rss+xml" title="" href="https://mipatente.cl/blog/x5feed.php">
		<link rel="canonical" href="https://mipatente.cl/aplicacion-para-grabado-de-vidrios.php">
		
		<!-- Google tag (gtag.js) -->
		<script async="" src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/js"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());
		
		  gtag('config', 'G-M8JCKMD4W9');
		</script>
		<!-- Global site tag (gtag.js) - Google Analytics --><script async="" src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/js"></script><script>window.dataLayer=window.dataLayer||[];function gtag(){dataLayer.push(arguments);}gtag('js', new Date());gtag('config', 'G-M8JCKMD4W9');</script>
	</head>
	<body bis_register="W3sibWFzdGVyIjp0cnVlLCJleHRlbnNpb25JZCI6ImVwcGlvY2VtaG1ubGJoanBsY2drb2ZjaWllZ29tY29uIiwiYWRibG9ja2VyU3RhdHVzIjp7IkRJU1BMQVkiOiJkaXNhYmxlZCIsIkZBQ0VCT09LIjoiZGlzYWJsZWQiLCJUV0lUVEVSIjoiZGlzYWJsZWQiLCJSRURESVQiOiJkaXNhYmxlZCIsIlBJTlRFUkVTVCI6ImRpc2FibGVkIiwiSU5TVEFHUkFNIjoiZGlzYWJsZWQiLCJMSU5LRURJTiI6ImRpc2FibGVkIiwiQ09ORklHIjoiZGlzYWJsZWQifSwidmVyc2lvbiI6IjIuMC4yMiIsInNjb3JlIjoyMDAyMn1d" __processed_91988f31-03bd-4eff-bef2-992fdd4da98e__="true">
		<!--<div id="imPageExtContainer" bis_skin_checked="1">
			<div id="imPageIntContainer" bis_skin_checked="1">
				<a class="screen-reader-only-even-focused" href="https://mipatente.cl/app-grabados-1.8-.php#imGoToCont" title="Salta el menu principal">Vaya al Contenido</a>
				<div id="imHeaderBg" bis_skin_checked="1"></div>
				<div id="imPage" bis_skin_checked="1">
					<header id="imHeader" style="">
						<h1 class="imHidden">Aplicacion online para generar plantillas para grabado de patentes - MiPatente.cl – Pintado y Grabados de Patentes en Chile.</h1>
						<!-- HeaderObjects -->
					</header>
					<div id="imStickyBarContainer" bis_skin_checked="1" style="margin-top: 0px; left: 0px; bottom: auto; z-index: 10302; transform: translateZ(0px); top: 0px; visibility: visible; overflow: visible;">
						<div id="imStickyBarGraphics" bis_skin_checked="1"></div>
						<div id="imStickyBar" bis_skin_checked="1">
							<!-- StickyBarObjects -->
						</div>
					</div>
					<div id="imSideBar" bis_skin_checked="1">
						<!-- SideBarObjects -->
					</div>
					<!--<div id="imContentGraphics" bis_skin_checked="1"></div>
					<main id="imContent">
						<a id="imGoToCont"></a>
						<div id="imPageRow_1" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_2" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_59" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_59" bis_skin_checked="1"><div style="position: relative; height: 100%;" bis_skin_checked="1"><div id="imCellStyleGraphicsC_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsT_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsTL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsTR_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsR_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsB_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsBL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsBR_59" bis_skin_checked="1"></div></div></div><div id="imCellStyleBorders_59" bis_skin_checked="1"></div><div id="imHTMLObject_54_59" class="imHTMLObject" style="text-align: center; width: 100%; overflow: hidden;" bis_skin_checked="1">
						
						
						    
						    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
						    <title>Generador de Patentes - MiPatente.cl</title>
						    <!-- Cargar fuentes de Google Fonts con pesos bold -->
						    <link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/css2" rel="stylesheet">
						    <style>
						        :root {
						            --primary-color: #00c897;
						            --secondary-color: #1d2d44;
						            --accent-color: #f48c06;
						            --history-button-color: #007bff;
						            --history-button-accent: #0056b3;
						            --text-color: #ffffff;
						            --border-radius: 8px;
						            --shadow-color: rgba(0, 0, 0, 0.2);
						            --input-height: 60px;
						            --file-input-height: 30px;
						        }
						
						        @font-face {
						            font-family: 'FE-FONT';
						            src: url('/FE-FONT.woff2') format('woff2'),
						                 url('/FE-FONT.ttf') format('truetype');
						            font-weight: normal;
						            font-style: normal;
						        }
						
						        body {
						            font-family: 'Poppins', sans-serif;
						            max-width: 1200px;
						            margin: 0 auto;
						            padding: 20px;
						            background: linear-gradient(135deg, #1d2d44 0%, #0a1a30 100%);
						            color: var(--text-color);
						            min-height: 100vh;
						            -webkit-font-smoothing: antialiased;
						            font-size: 16px;
						        }
						
						        .container {
						            background: rgba(29, 45, 68, 0.95);
						            padding: 30px;
						            border-radius: var(--border-radius);
						            box-shadow: 0 10px 30px var(--shadow-color);
						            border: 1px solid rgba(255, 255, 255, 0.1);
						        }
						
						        h1 {
						            color: #ffffff;
						            font-size: 1.8rem;
						            text-align: center;
						            margin-bottom: 1rem;
						            font-weight: 600;
						            font-family: 'Montserrat', sans-serif;
						            letter-spacing: 2px;
						        }
						
						        .preview-area {
						            border: 2px solid var(--primary-color);
						            padding: 20px;
						            margin: 15px 0;
						            background: rgba(255, 255, 255, 0.05);
						            text-align: center;
						            border-radius: var(--border-radius);
						            transition: transform 0.3s ease, box-shadow 0.3s ease;
						        }
						
						        .preview-area:hover {
						            transform: scale(1.02);
						            box-shadow: 0 8px 20px var(--shadow-color);
						        }
						
						        canvas {
						            max-width: 100%;
						            background: rgba(255, 255, 255, 0.1);
						            border-radius: var(--border-radius);
						            border: 5px solid var(--primary-color);
						            box-shadow: 0 6px 15px var(--shadow-color);
						        }
						
						        .input-group {
						            margin-bottom: 15px;
						            max-width: 350px;
						            margin-left: auto;
						            margin-right: auto;
						            display: flex;
						            flex-direction: column;
						            gap: 8px;
						        }
						
						        .logo-controls {
						            display: flex;
						            flex-direction: column;
						            gap: 8px;
						            margin-bottom: 10px;
						            max-width: 350px;
						            margin-left: auto;
						            margin-right: auto;
						        }
						
						        .font-controls {
						            display: flex;
						            flex-direction: row;
						            gap: 8px;
						            margin: 10px auto;
						            max-width: 350px;
						            align-items: center;
						        }
						
						        .font-controls > div {
						            flex: 1;
						            min-width: 0;
						        }
						
						        .font-size-buttons {
						            display: flex;
						            flex-direction: column;
						            gap: 5px;
						            align-items: center;
						            min-width: 60px;
						        }
						
						        .font-size-buttons button {
						            width: 40px;
						            height: 40px;
						            padding: 0;
						            font-size: 1.2rem;
						            min-width: 0;
						            margin: 0;
						            border-radius: 8px;
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            color: var(--text-color);
						            border: none;
						            cursor: pointer;
						            transition: all 0.3s ease;
						        }
						
						        .font-size-buttons button:hover {
						            transform: translateY(-2px);
						            box-shadow: 0 6px 20px var(--shadow-color);
						        }
						
						        .font-size-buttons label {
						            font-size: 1.1rem;
						            margin-bottom: 5px;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						            white-space: nowrap;
						        }
						
						        #fontSizeValue {
						            font-size: 1.1rem;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						            margin: 0 5px;
						            min-width: 40px;
						            text-align: center;
						        }
						
						        .new-patent-input {
						            max-width: 200px;
						            margin: 0 auto;
						            padding: 10px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						        }
						
						        .new-patent-input label {
						            font-size: 1.2rem;
						            text-align: center;
						            margin-bottom: 8px;
						        }
						
						        #textInput {
						            font-family: 'Poppins', sans-serif;
						            font-size: 2rem;
						            text-align: center;
						            height: 50px;
						            width: 100%;
						            padding: 5px;
						            border: none;
						            background: transparent;
						            color: var(--text-color);
						        }
						
						        .mode-buttons {
						            display: flex;
						            gap: 5px;
						            justify-content: center;
						            margin: 10px 0;
						        }
						
						        .mode-button {
						            width: 80px;
						            height: 40px;
						            padding: 0;
						            font-size: 1rem;
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            cursor: pointer;
						            transition: all 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        .mode-button.active {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            border: none;
						            box-shadow: 0 4px 15px var(--shadow-color);
						        }
						
						        .mode-button:hover:not(.active) {
						            background: rgba(255, 255, 255, 0.2);
						        }
						
						        .toggle-button {
						            width: 120px;
						            height: 40px;
						            padding: 0;
						            font-size: 1rem;
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            cursor: pointer;
						            transition: all 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        .toggle-button.active {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            border: none;
						            box-shadow: 0 4px 15px var(--shadow-color);
						        }
						
						        .toggle-button:hover:not(.active) {
						            background: rgba(255, 255, 255, 0.2);
						        }
						
						        .format-controls {
						            display: flex;
						            gap: 8px;
						            justify-content: center;
						            align-items: center;
						            margin: 10px 0;
						        }
						
						        .format-type-select {
						            width: 100px;
						            height: 35px;
						            padding: 0 8px;
						            font-size: 0.9rem;
						            border-radius: var(--border-radius);
						            background: var(--secondary-color);
						            color: #000000;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            font-family: 'Poppins', sans-serif;
						            transition: all 0.3s ease;
						            -webkit-appearance: none;
						            -moz-appearance: none;
						            appearance: none;
						            background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 8px center;
						            background-size: 18px;
						        }
						
						        .format-type-select:focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						            background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 8px center;
						        }
						
						        .format-type-select option {
						            background: var(--secondary-color);
						            color: #000000;
						        }
						
						        @media (max-width: 480px) {
						            #textInput {
						                font-size: 1.8rem;
						                height: 40px;
						                padding: 10px 5px;
						            }
						
						            :root {
						                --input-height: 50px;
						            }
						
						            h1 {
						                font-size: 1.3rem;
						            }
						
						            .font-controls {
						                flex-direction: row;
						                gap: 5px;
						            }
						
						            .font-controls label {
						                font-size: 1rem;
						            }
						
						            .font-controls select {
						                font-size: 1rem;
						                padding: 10px;
						            }
						
						            .input-group, .logo-controls, .font-controls {
						                max-width: 100%;
						            }
						
						            button {
						                max-width: 100%;
						            }
						
						            .new-patent-input label {
						                font-size: 1.5rem;
						            }
						
						            label {
						                font-size: 1.2rem;
						            }
						
						            input, select {
						                font-size: 1.2rem;
						                padding: 12px;
						            }
						
						            .mode-button {
						                width: 60px;
						                height: 35px;
						                font-size: 0.9rem;
						            }
						
						            .toggle-button {
						                width: 100px;
						                height: 35px;
						                font-size: 0.9rem;
						            }
						
						            .format-type-select {
						                width: 80px;
						                height: 30px;
						                font-size: 0.8rem;
						                padding: 0 6px;
						                background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="20" viewBox="0 0 24 24" width="20" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 6px center;
						                background-size: 16px;
						            }
						        }
						
						        @media screen and (-webkit-min-device-pixel-ratio: 0) { 
						            #textInput {
						                font-size: 16px !important;
						            }
						            #textInput:focus {
						                font-size: 1.8rem !important;
						            }
						        }
						
						        @media (max-width: 768px) {
						            .container {
						                padding: 20px;
						                margin: 10px;
						                border-radius: 12px;
						            }
						
						            h1 {
						                font-size: 1.5rem;
						            }
						
						            .preview-area {
						                padding: 15px;
						            }
						
						            .controls-container {
						                flex-direction: column;
						                gap: 15px;
						            }
						
						            .control-group {
						                width: 100%;
						            }
						
						            .logo-controls {
						                flex-direction: column;
						                gap: 10px;
						                max-width: 100%;
						            }
						
						            .font-controls {
						                flex-direction: row;
						                gap: 8px;
						                max-width: 100%;
						            }
						
						            .input-group, .logo-controls, .font-controls {
						                max-width: 100%;
						            }
						
						            .new-patent-input {
						                max-width: 100%;
						            }
						
						            button {
						                max-width: 100%;
						            }
						
						            .new-patent-input label {
						                font-size: 1.5rem;
						            }
						
						            #textInput {
						                font-size: 2rem;
						            }
						
						            label {
						                font-size: 1.2rem;
						            }
						
						            input, select {
						                font-size: 1.2rem;
						                padding: 12px;
						            }
						        }
						
						        .controls-container {
						            display: flex;
						            justify-content: center;
						            gap: 20px;
						            margin-top: 15px;
						            background: rgba(255, 255, 255, 0.05);
						            padding: 15px;
						            border-radius: var(--border-radius);
						            max-width: 600px;
						            margin-left: auto;
						            margin-right: auto;
						        }
						
						        .control-group {
						            width: 180px;
						            text-align: center;
						        }
						
						        .control-group label {
						            font-size: 1rem;
						            margin-bottom: 8px;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        label {
						            display: block;
						            margin-bottom: 8px;
						            font-weight: 600;
						            color: var(--text-color);
						            font-size: 1.1rem;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input, select {
						            width: 100%;
						            height: var(--input-height);
						            padding: 10px;
						            margin-bottom: 10px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            font-size: 1.1rem;
						            transition: all 0.3s ease;
						            background: rgba(255, 255, 255, 0.1);
						            box-shadow: inset 0 2px 6px var(--shadow-color);
						            color: var(--text-color);
						            font-family: 'Poppins', sans-serif;
						            line-height: 1;
						        }
						
						        #jpgLogoSelect, 
						        #logoInput {
						            border-radius: var(--border-radius);
						        }
						
						        select:not(.format-type-select) {
						            -webkit-appearance: none;
						            -moz-appearance: none;
						            appearance: none;
						            background: rgba(255, 255, 255, 0.1) url('data:image/svg+xml;utf8,<svg fill="%23ffffff" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 12px center;
						            background-size: 20px;
						        }
						
						        select:not(.format-type-select):focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						            background: rgba(255, 255, 255, 0.1) url('data:image/svg+xml;utf8,<svg fill="%23ffffff" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 12px center;
						        }
						
						        select:not(.format-type-select) option {
						            background: rgba(29, 45, 68, 0.95);
						            color: var(--text-color);
						        }
						
						        input[type="range"] {
						            padding: 0;
						            height: 8px;
						            accent-color: var(--accent-color);
						            -webkit-appearance: none;
						            background: rgba(255, 255, 255, 0.2);
						            border-radius: 4px;
						        }
						
						        input[type="range"]::-webkit-slider-thumb {
						            -webkit-appearance: none;
						            width: 20px;
						            height: 20px;
						            background: var(--accent-color);
						            border-radius: 50%;
						            border: 2px solid rgba(255, 255, 255, 0.3);
						            box-shadow: 0 2px 6px var(--shadow-color);
						        }
						
						        input[type="range"]::-moz-range-thumb {
						            width: 20px;
						            height: 20px;
						            background: var(--accent-color);
						            border-radius: 50%;
						            border: 2px solid rgba(255, 255, 255, 0.3);
						            box-shadow: 0 2px 6px var(--shadow-color);
						        }
						
						        input:focus, select:focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						        }
						
						        .file-input-wrapper {
						            margin-bottom: 10px;
						        }
						
						        input[type="file"] {
						            height: var(--file-input-height);
						            padding: 5px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            font-size: 1rem;
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            line-height: 1;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input[type="file"]::-webkit-file-upload-button {
						            height: 100%;
						            background: var(--primary-color);
						            color: var(--text-color);
						            border: none;
						            padding: 5px 15px;
						            border-radius: 6px;
						            font-weight: 600;
						            font-size: 1rem;
						            transition: background 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input[type="file"]::-webkit-file-upload-button:hover {
						            background: var(--accent-color);
						        }
						
						        input[type="file"]::file-selector-button {
						            height: 100%;
						            background: var(--primary-color);
						            color: var(--text-color);
						            border: none;
						            padding: 5px 15px;
						            border-radius: 6px;
						            font-weight: 600;
						            font-size: 1rem;
						            transition: background 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        button {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            color: var(--text-color);
						            padding: 14px 24px;
						            border: none;
						            border-radius: var(--border-radius);
						            cursor: pointer;
						            width: 100%;
						            font-size: 1.2rem;
						            font-weight: 600;
						            transition: all 0.3s ease;
						            box-shadow: 0 4px 15px var(--shadow-color);
						            max-width: 300px;
						            margin-left: auto;
						            margin-right: auto;
						            margin-bottom: 20px;
						            display: block;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        button.history-button {
						            background: linear-gradient(45deg, var(--history-button-color), var(--history-button-accent));
						        }
						
						        button:hover {
						            transform: translateY(-2px);
						            box-shadow: 0 6px 20px var(--shadow-color);
						        }
						
						        .header-logo {
						            display: block;
						            margin: 0 auto 20px auto;
						            max-width: 200px;
						            height: auto;
						        }
						
						        #patentHistoryWindow {
						            display: none;
						            position: fixed;
						            top: 50%;
						            left: 50%;
						            transform: translate(-50%, -50%);
						            background: rgba(29, 45, 68, 0.95);
						            padding: 20px;
						            border-radius: var(--border-radius);
						            box-shadow: 0 10px 30px var(--shadow-color);
						            border: 1px solid rgba(255, 255, 255, 0.1);
						            max-width: 400px;
						            width: 90%;
						            max-height: 400px;
						            overflow-y: auto;
						            z-index: 1000;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar {
						            width: 12px;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar-thumb {
						            background: var(--primary-color);
						            border-radius: 6px;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar-track {
						            background: rgba(255, 255, 255, 0.1);
						        }
						
						        #patentHistoryWindow h2 {
						            font-size: 1.5rem;
						            margin-bottom: 15px;
						            text-align: center;
						        }
						
						        #patentList {
						            list-style: none;
						            padding: 0;
						            margin: 0;
						        }
						
						        #patentList li {
						            padding: 10px;
						            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
						            display: flex;
						            justify-content: space-between;
						            align-items: center;
						        }
						
						        #patentList li:last-child {
						            border-bottom: none;
						        }
						
						        .close-button {
						            background: var(--accent-color);
						            padding: 10px 20px;
						            margin-top: 15px;
						            max-width: 100px;
						        }
						    </style>
						
						          
						    <!--<div class="container" bis_skin_checked="1">
						       <!-- <img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/logo2.webp" alt="Logo" class="header-logo">
						       
						  <h1>v1.8-2025</h1>-->   
						        <div class="input-group" id="logoSection" bis_skin_checked="1" style="display: block;">
						            <div class="logo-controls" bis_skin_checked="1">
						                <div bis_skin_checked="1">
						                    <!--<label>Cargar logo:</label>
						                    <div class="file-input-wrapper" bis_skin_checked="1">
						                        <input type="file" id="logoInput" accept="image/*">
						                    </div>
						                </div>-->
						               <!-- <div bis_skin_checked="1">
						                    <label>Logos:</label>
						                    <select id="jpgLogoSelect" onchange="handleJpgLogoSelect()">
						                        <option value="">Seleccionar</option>
						                        <option value="ALFA ROMEO.jpg">ALFA ROMEO</option>
						                        <option value="Audi.jpg">Audi</option>
						                        <option value="Audi2.jpg">Audi2</option>
						                        <option value="Baic group.jpg">Baic Group</option>                     
						                        <option value="BMW.jpg">BMW</option>
						                        <option value="Byd.jpg">Byd</option>
						                        <option value="brilliance.jpg">Brilliance</option>                  
						                        <option value="Changan.jpg">Changan</option>
						                        <option value="chery.jpg">Chery</option>
						                        <option value="Cherry.jpg">Cherry</option>                       
						                        <option value="Chevrolet.jpg">Chevrolet</option>
						                        <option value="Citroen.jpg">Citroen</option>
						                        <option value="Daewoo.jpg">Daewoo</option>
						                        <option value="Dfsk.jpg">Dfsk</option>                       
						                        <option value="Donge.jpg">Donge</option>
						                        <option value="dongfeng.jpg">dongfeng</option>                     
						                        <option value="Faw.jpg">Faw</option>                   
						                        <option value="FIAT2.jpg">FIAT1</option>
						                        <option value="FIAT.jpg">FIAT2</option>
						                        <option value="Ford.jpg">Ford</option>
						                        <option value="foton.jpg">Foton.jpg</option>
						                        <option value="Geely.jpg">Geely</option>
						                        <option value="Great Wall.jpg">Great Wall</option>
						                        <option value="Honda.jpg">Honda</option>
						                        <option value="honda2.jpg">honda2</option>
						                        <option value="Hyundai Motor.jpg">Hyundai Motor</option>
						                        <option value="Hyundai.jpg">Hyundai</option>
						                        <option value="isuzu.jpg">Isuzu</option>
						                        <option value="JAC motor.jpg">JAC motor</option>
						                        <option value="Jaguar.jpg">Jaguar</option>
						                        <option value="Jeep.jpg">Jeep</option>
						                        <option value="JMC1.jpg">JMC1</option>
						                        <option value="KIA1.jpg">KIA1</option>
						                        <option value="KIA2.jpg">KIA2</option>
						                        <option value="Land Rover.jpg">Land Rover</option>
						                        <option value="Lexus.jpg">Lexus</option>
						                        <option value="Lexus2.jpg">Lexus2</option>
						                        <option value="lifan.jpg">Lifan</option>
						                        <option value="maxus.jpeg">Maxus</option>
						                        <option value="mahindra.jpg">Mahindra</option>
						                        <option value="Mazda.jpg">Mazda</option>
						                        <option value="Mercedes Benz.jpg">Mercedes Benz</option>
						                        <option value="MG.jpg">MG</option>
						                        <option value="Mini.jpg">Mini</option>
						                        <option value="Mitsubishi.jpg">Mitsubishi</option>
						                        <option value="Nissan.jpg">Nissan</option>
						                        <option value="NISSAN2.jpg">NISSAN2</option>
						                        <option value="Peugeot.jpg">Peugeot</option>
						                        <option value="Porsche.jpg">Porsche</option>
						                        <option value="Porsche2.jpg">Porsche2</option>
						                        <option value="Renault.jpg">Renault</option>
						                        <option value="Renault2.jpg">Renault2</option>
						                        <option value="Scania.jpg">Scania</option>
						                        <option value="Scania2.jpg">Scania2</option>
						                        <option value="Seat.jpg">Seat</option>
						                        <option value="SEAT2.jpg">SEAT2</option>
						                        <option value="Skoda.jpg">Skoda</option>
						                        <option value="SsangYong.jpg">SsangYong</option>
						                        <option value="SsangYong2.jpg">SsangYong2</option>
						                        <option value="Subaru.jpg">Subaru</option>
						                        <option value="Subaru2.jpg">Subaru2</option>
						                        <option value="Suzuki.jpg">Suzuki</option>
						                        <option value="Suzuki2.jpg">Suzuki2</option>
						                        <option value="TESLA.jpg">TESLA</option>
						                        <option value="Toyota.jpg">Toyota</option>
						                        <option value="Opel.jpg">Opel</option>
						                        <option value="Volkswagen.jpg">Volkswagen</option>
						                        <option value="Volkswagen2.jpg">Volkswagen2</option>
						                        <option value="Volvo.jpg">Volvo</option>
						                        <option value="Volvo2.jpg">Volvo2</option>                                                                                                                       
						                    </select>
						                </div>
						            </div>
						        </div>-->
						        <div class="input-group" bis_skin_checked="1">
						            <!--<div class="new-patent-input" bis_skin_checked="1">
						               <!-- <label for="textInput">Patente:</label>
						                <input type="text" style="text-transform: uppercase" id="textInput" placeholder="6 caracteres" maxlength="6">
						            </div>
						            <!--<div class="mode-buttons" bis_skin_checked="1">
						                <button class="mode-button active" data-mode="280" onclick="selectMode(&#39;280&#39;)">Logos</button>
						                <button class="mode-button" data-mode="200" onclick="selectMode(&#39;200&#39;)">Letras</button>
						                <button class="mode-button" data-mode="auto" onclick="selectMode(&#39;auto&#39;)">Ecomi</button>
						            </div>
						            <div class="format-controls" bis_skin_checked="1">
						                <button class="toggle-button" id="formatToggle" onclick="toggleFormat()">Formato: OFF</button>
						                <select id="formatTypeSelect" onchange="saveSettings(); updateCanvas()" style="display: none;">
						                    <option value="1">AB-CD-EF</option>
						                    <option value="2">AB·CD·EF</option>
						                    <option value="3">AB·CD-EF</option>
						                    <option value="4">AB-CD·EF</option>
						                </select>
						            </div>
						        </div>
						        <div class="preview-area" bis_skin_checked="1">
						            <canvas id="previewCanvas" width="420" height="280"></canvas>
						            <div class="font-controls" bis_skin_checked="1">
						                <div bis_skin_checked="1">
						                    <label>Estilos:</label>
						                    <select id="styleSelect" onchange="updateCanvas()">
						                        <option value="normal" selected="">Normal</option>
						                        <option value="bold">Negritas</option>
						                    </select>
						                </div>
						                <div bis_skin_checked="1">
						                    <label>Fuentes:</label>
						                    <select id="fontSelect" onchange="saveSettings(); updateCanvas()">
						                        <option value="Roboto Condensed">Roboto Condensed</option>
						                        <option value="monospace">Monospace</option>
						                        <option value="FE-FONT">FE-FONT</option>
						                        <option value="serif">Serif</option>
						                        <option value="Arial">Arial</option>
						                        <option value="Times">Times</option>
						                        <option value="Poppins">Poppins</option>
						                    </select>
						                </div>
						                <div class="font-size-buttons" bis_skin_checked="1">
						                    <label>Tamaño:</label>
						                    <span id="fontSizeValue">95</span>
						                    <button type="button" onclick="changeFontSize(5)">+</button>
						                    <button type="button" onclick="changeFontSize(-5)">-</button>
						                </div>
						            </div>
						            <div class="controls-container" bis_skin_checked="1">
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="spacingSlider">Espaciado</label>
						                    <input type="range" id="spacingSlider" min="0" max="150" value="50">
						                </div>
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="sizeSlider">Tamaño Logo</label>
						                    <input type="range" id="sizeSlider" min="20" max="100" value="45">
						                </div>
						            </div>
						        </div>
						        <button onclick="imprimirCanvas()">Descargar Patente</button>
						        <!--<button class="history-button" onclick="showPatentHistory()">Ver Registro de Patentes</button>
						        <div id="patentHistoryWindow" bis_skin_checked="1">
						            <h2>Registro de Patentes</h2>
						            <ul id="patentList"></ul>
						            <button class="close-button" onclick="closePatentHistory()">Cerrar</button>
						        </div>
						    </div>-->
						    <script>
						        const canvas = document.getElementById('previewCanvas');
						        const ctx = canvas.getContext('2d');
						        let currentLogo = null;
						        let fontSize = localStorage.getItem('fontSize') ? parseInt(localStorage.getItem('fontSize')) : 95;
						        let currentMode = localStorage.getItem('canvasHeightSelect') || '280';
						        let isFormatted = localStorage.getItem('isFormatted') === 'true';
						        let formatType = localStorage.getItem('formatType') || '1';
						        let patentHistory = JSON.parse(localStorage.getItem('patentHistory')) || [];
						
						        window.onload = function() {
						            const savedFont = localStorage.getItem('fontSelect');
						            const savedMode = localStorage.getItem('canvasHeightSelect');
						            const savedFormatType = localStorage.getItem('formatType');
						            if (savedFont) {
						                document.getElementById('fontSelect').value = savedFont;
						            } else {
						                document.getElementById('fontSelect').value = 'Roboto Condensed';
						            }
						            if (savedMode) {
						                currentMode = savedMode;
						                selectMode(savedMode, false);
						            } else {
						                selectMode('280', false);
						            }
						            if (savedFormatType) {
						                formatType = savedFormatType;
						                document.getElementById('formatTypeSelect').value = savedFormatType;
						            }
						            document.getElementById('fontSizeValue').textContent = fontSize;
						            updateFormatButton();
						            updateCanvas();
						        };
						
						        function handleJpgLogoSelect() {
						            const jpgLogoSelect = document.getElementById('jpgLogoSelect');
						            const selectedJpgLogo = jpgLogoSelect.value;
						            if (selectedJpgLogo) {
						                const img = new Image();
						                img.onload = function() {
						                    currentLogo = img;
						                    updateCanvas();
						                };
						                img.onerror = function() {
						                    console.error(`Error al cargar el logo: ./logos/${selectedJpgLogo}`);
						                    currentLogo = null;
						                    updateCanvas();
						                };
						                img.src = `./logos/${selectedJpgLogo}`;
						                document.getElementById('logoInput').value = '';
						            }
						        }
						
						        document.getElementById('logoInput').addEventListener('change', function(e) {
						            const file = e.target.files[0];
						            if (file) {
						                const reader = new FileReader();
						                reader.onload = function(event) {
						                    const img = new Image();
						                    img.onload = function() {
						                        currentLogo = img;
						                        updateCanvas();
						                    };
						                    img.onerror = function() {
						                        console.error('Error al cargar el logo subido');
						                        currentLogo = null;
						                        updateCanvas();
						                    };
						                    img.src = event.target.result;
						                };
						                reader.readAsDataURL(file);
						                document.getElementById('jpgLogoSelect').value = '';
						            } else {
						                document.getElementById('logoInput').value = 'Sin archivos';
						            }
						        });
						
						        document.getElementById('textInput').addEventListener('input', function() {
						            updateCanvas();
						            if (this.value.length === 6) {
						                this.blur();
						            }
						        });
						        document.getElementById('spacingSlider').addEventListener('input', updateCanvas);
						        document.getElementById('sizeSlider').addEventListener('input', updateCanvas);
						        document.getElementById('styleSelect').addEventListener('change', updateCanvas);
						        document.getElementById('fontSelect').addEventListener('change', updateCanvas);
						        document.getElementById('formatTypeSelect').addEventListener('change', function() {
						            formatType = this.value;
						            saveSettings();
						            updateCanvas();
						        });
						
						        function saveSettings() {
						            const fontSelect = document.getElementById('fontSelect').value;
						            localStorage.setItem('fontSelect', fontSelect);
						            localStorage.setItem('fontSize', fontSize);
						            localStorage.setItem('canvasHeightSelect', currentMode);
						            localStorage.setItem('isFormatted', isFormatted);
						            localStorage.setItem('formatType', formatType);
						        }
						
						        function changeFontSize(delta) {
						            const newSize = fontSize + delta;
						            if (newSize >= 65 && newSize <= 110) {
						                fontSize = newSize;
						                document.getElementById('fontSizeValue').textContent = fontSize;
						                saveSettings();
						                updateCanvas();
						            }
						        }
						
						        function selectMode(mode, save = true) {
						            currentMode = mode;
						            const buttons = document.querySelectorAll('.mode-button');
						            buttons.forEach(button => {
						                button.classList.remove('active');
						                if (button.getAttribute('data-mode') === mode) {
						                    button.classList.add('active');
						                }
						            });
						
						            const logoSection = document.getElementById('logoSection');
						            if (mode === "280") {
						                canvas.height = 280;
						                logoSection.style.display = 'block';
						            } else if (mode === "200") {
						                canvas.height = 200;
						                logoSection.style.display = 'none';
						                currentLogo = null;
						            } else if (mode === "auto") {
						                logoSection.style.display = 'none';
						                currentLogo = null;
						            }
						            
						            if (save) saveSettings();
						            updateCanvas();
						        }
						
						        function toggleFormat() {
						            isFormatted = !isFormatted;
						            updateFormatButton();
						            saveSettings();
						            updateCanvas();
						        }
						
						        function updateFormatButton() {
						            const formatButton = document.getElementById('formatToggle');
						            const formatTypeSelect = document.getElementById('formatTypeSelect');
						            formatButton.textContent = `Formato: ${isFormatted ? 'ON' : 'OFF'}`;
						            if (isFormatted) {
						                formatButton.classList.add('active');
						                formatTypeSelect.style.display = 'inline-block';
						            } else {
						                formatButton.classList.remove('active');
						                formatTypeSelect.style.display = 'none';
						            }
						        }
						
						        function formatText(text) {
						            if (text.length === 6) {
						                const pair1 = text.substring(0, 2);
						                const pair2 = text.substring(2, 4);
						                const pair3 = text.substring(4, 6);
						                switch (formatType) {
						                    case '1':
						                        return `${pair1}-${pair2}-${pair3}`;
						                    case '2':
						                        return `${pair1}·${pair2}·${pair3}`;
						                    case '3':
						                        return `${pair1}·${pair2}-${pair3}`;
						                    case '4':
						                        return `${pair1}-${pair2}·${pair3}`;
						                    default:
						                        return text;
						                }
						            }
						            return text;
						        }
						
						        function updateCanvas() {
						            let text = document.getElementById('textInput').value;
						            const styleSelect = document.getElementById('styleSelect').value;
						            const fontSelect = document.getElementById('fontSelect').value;
						            const spacingValue = document.getElementById('spacingSlider').value;
						            const sizeValue = document.getElementById('sizeSlider').value;
						            const spacing = (spacingValue / 100) * (canvas.height * 0.5);
						            const isMobile = window.innerWidth <= 768;
						
						            if (isFormatted && text) {
						                text = formatText(text);
						            }
						
						            if (currentMode === "auto" && text) {
						                const fontWeight = styleSelect === 'bold' ? '700' : '400';
						                let fontFamily = fontSelect;
						                let baseFontSize = isFormatted ? fontSize * 0.85 : fontSize;
						                ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                
						                let textWidth = ctx.measureText(text.toUpperCase()).width;
						                while (textWidth > canvas.width * 0.88) {
						                    baseFontSize--;
						                    ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                    textWidth = ctx.measureText(text.toUpperCase()).width;
						                }
						                
						                const textHeight = baseFontSize;
						                const topMargin = isMobile ? 30 : 20;
						                const bottomMargin = 20;
						                canvas.height = textHeight + topMargin + bottomMargin;
						            }
						
						            ctx.fillStyle = 'white';
						            ctx.fillRect(0, 0, canvas.width, canvas.height);
						            
						            if (currentLogo && currentMode === "280") {
						                const logoHeight = canvas.height * (sizeValue / 100);
						                const logoWidth = (currentLogo.width * logoHeight) / currentLogo.height;
						                const x = (canvas.width - logoWidth) / 2;
						                const y = (canvas.height - logoHeight - spacing) / 3;
						                ctx.drawImage(currentLogo, x, y, logoWidth, logoHeight);
						            }
						
						            if (text) {
						                const fontWeight = styleSelect === 'bold' ? '700' : '400';
						                let fontFamily = fontSelect;
						                let baseFontSize = isFormatted ? fontSize * 0.85 : fontSize;
						                ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                
						                let textWidth = ctx.measureText(text.toUpperCase()).width;
						                while (textWidth > canvas.width * 0.88) {
						                    baseFontSize--;
						                    ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                    textWidth = ctx.measureText(text.toUpperCase()).width;
						                }
						                
						                ctx.fillStyle = 'black';
						                ctx.textAlign = 'center';
						                ctx.textBaseline = 'middle';
						                
						                let textY;
						                if (currentMode === "280" && currentLogo) {
						                    textY = ((canvas.height + spacing) / 2) + (canvas.height * 0.15);
						                } else if (currentMode === "auto") {
						                    const topMargin = isMobile ? 30 : 20;
						                    textY = topMargin + (baseFontSize / 2);
						                } else {
						                    textY = canvas.height / 2;
						                }
						                
						                ctx.fillText(text.toUpperCase(), canvas.width / 2, textY);
						            }
						        }
						
						        function savePatentToHistory(patente, timestamp, logoName) {
						            patentHistory.push({ patente, timestamp, logoName });
						            localStorage.setItem('patentHistory', JSON.stringify(patentHistory));
						        }
						
						        function showPatentHistory() {
						            const patentList = document.getElementById('patentList');
						            patentList.innerHTML = '';
						            const sortedHistory = patentHistory.slice().reverse();
						            sortedHistory.forEach(entry => {
						                const li = document.createElement('li');
						                li.textContent = `${entry.patente} - Logo: ${entry.logoName || 'Ninguno'} - ${new Date(entry.timestamp).toLocaleString()}`;
						                patentList.appendChild(li);
						            });
						            const patentWindow = document.getElementById('patentHistoryWindow');
						            patentWindow.style.display = 'block';
						            if (patentHistory.length > 8) {
						                const lastItem = patentList.children[7];
						                if (lastItem) {
						                    lastItem.scrollIntoView({ behavior: 'smooth', block: 'start' });
						                }
						            }
						        }
						
						        function closePatentHistory() {
						            document.getElementById('patentHistoryWindow').style.display = 'none';
						        }
						
						        function generateAndDownload() {
						            const mirrorCanvas = document.createElement('canvas');
						            mirrorCanvas.width = canvas.width;
						            mirrorCanvas.height = canvas.height;
						            const mctx = mirrorCanvas.getContext('2d');
						            
						            mctx.scale(-1, 1);
						            mctx.drawImage(canvas, -canvas.width, 0);
						            
						            const patente = document.getElementById('textInput').value.toUpperCase();
						            const timestamp = new Date().toISOString();
						            const jpgLogoSelect = document.getElementById('jpgLogoSelect');
						            const logoInput = document.getElementById('logoInput');
						            let logoName = jpgLogoSelect.value || (logoInput.files.length > 0 ? logoInput.files[0].name : 'Ninguno');
						            
						            if (patente) {
						                savePatentToHistory(patente, timestamp, logoName);
						            }
						            
						            const { jsPDF } = window.jspdf;

const canvasData = mirrorCanvas.toDataURL("image/png");

const pdf = new jsPDF({
    orientation: "landscape", // o "portrait" si tu canvas es vertical
    unit: "pt",
    format: [mirrorCanvas.width, mirrorCanvas.height]
});

pdf.addImage(canvasData, 'PNG', 0, 0, mirrorCanvas.width, mirrorCanvas.height);
pdf.save('patente.pdf');

						
						            fetch('https://api.ipify.org?format=json')
						                .then(response => response.json())
						                .then(data => {
						                    const ip = data.ip;
						                    
						                    fetch('https://script.google.com/macros/s/AKfycbwerX85XPRpVIEi44h8sMKvoF2iCfScub3H5o-VxMfnAbW4710vR8smIALyGjiQeOkj/exec', {
						                        method: 'POST',
						                        mode: 'no-cors',
						                        headers: {
						                            'Content-Type': 'application/json',
						                        },
						                        body: JSON.stringify({
						                            patente: patente,
						                            ip: ip,
						                            timestamp: timestamp,
						                            logoName: logoName
						                        })
						                    })
						                    .then(() => {
						                        console.log('Solicitud enviada a Google Sheets (no-cors)');
						                    })
						                    .catch(error => {
						                        console.error('Error en la solicitud a Google Sheets:', error);
						                    });
						                })
						                .catch(error => {
						                    console.error('Error al obtener IP:', error);
						                });
						        }
						
						        ctx.fillStyle = 'white';
						        ctx.fillRect(0, 0, canvas.width, canvas.height);
						    </script>
						
						</div></div><div id="imPageRow_3" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_19" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_19" bis_skin_checked="1"></div><div id="imCellStyleBorders_19" bis_skin_checked="1"></div><div id="imHTMLObject_54_19" class="imHTMLObject" style="text-align: center; width: 100%; overflow: hidden;" bis_skin_checked="1">
						
						
						   
						   <meta name="viewport" content="width=device-width, initial-scale=1.0">
						   <title>Obtener IP del visitante</title>
						   <style>
						       h1 {
						           font-size: 14px;
						             text-align: center;

						       }
						       p {
						           font-size: 14px;
						             text-align: center;

						       }
						   </style>
						
						
						   <!--<h1>Tu IP Actual:</h1>
						   <p id="ip-address">190.45.25.37</p>
						
						   <script>
						       // Función para obtener la IP
						       async function getIP() {
						           try {
						               const response = await fetch('https://api.ipify.org?format=json');
						               if (!response.ok) {
						                   throw new Error('Error en la solicitud: ' + response.status);
						               }
						               const data = await response.json();
						               document.getElementById('ip-address').textContent = data.ip;
						           } catch (error) {
						               document.getElementById('ip-address').textContent = 'Error al obtener la IP';
						               console.error('Detalles del error:', error);
						           }
						       }
						
						       // Ejecutar la función al cargar la página
						       getIP();
						   </script>
						
						</div></div><div id="imPageRow_4" class="imPageRow" bis_skin_checked="1">
						
						</div>
					<!--	<div id="imCell_9" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_9" bis_skin_checked="1"></div><div id="imCellStyleBorders_9" bis_skin_checked="1"></div><!-- Login & Logout v.1 borrar aqui <div id="pluginAppObj_54_09" bis_skin_checked="1"><div id="imLogin" class="imLoginC no_display layout_column" bis_skin_checked="1">    <div id="area-a-imprimir"><form method="post" action="https://mipatente.cl/imlogin.php" onsubmit="_jq(this).attr(&#39;action&#39;, x5engine.settings.currentPath + &#39;imlogin.php&#39;); return (x5engine.utils.isOnline() || !x5engine.utils.showOfflineMessage(&#39;Login &amp; Logout - &#39;+x5engine.l10n.get(&#39;cmn_only_when_online&#39;),undefined,undefined,undefined,&#39;loginlogout_&#39;+x5engine.l10n.get(&#39;cmn_only_when_online&#39;),0));" data-gtm-form-interact-id="0">     <div class="imLoginBlockInputWrapper" bis_skin_checked="1">        <div class="imLoginBlock imLoginBlockInput loginfontSize" bis_skin_checked="1">            <label for="imUname_pluginAppObj_54_09" class="loginfontSize"><span class=" loginLabelCustomStyle loginLabelOptionStyle ">Nombre del usuario:</span></label>            <input type="text" name="imUname" id="imUname_pluginAppObj_54_09" class=" loginInputCustomStyle loginInputOptionStyle " data-gtm-form-interact-field-id="0">        </div>        <div class="imLoginBlock imLoginBlockInput loginfontSize" bis_skin_checked="1">            <label for="imPwd_pluginAppObj_54_09" class="loginfontSize"><span class=" loginLabelCustomStyle loginLabelOptionStyle ">Contraseña:</span></label>            <input type="password" name="imPwd" id="imPwd_pluginAppObj_54_09" class=" loginInputCustomStyle loginInputOptionStyle " data-gtm-form-interact-field-id="1">        </div>     </div>        <div class="imLoginBlock imLoginBlockPulsante loginfontSize" bis_skin_checked="1">            <input type="submit" value="Intro" class="imLoginSubmit  btnCustomStyle btnOptionStyle ">        </div>    </form></div></div><div class="imLogoutC" bis_skin_checked="1"><span class="logout_intro customStyle">Hola Marcelo</span><a class="imLogoutAnchor customStyle customOption" href="https://mipatente.cl/res/imlogout.php">Cerrar Sesion</a></div>
						<script>
						    loginlogout_pluginAppObj_54_09();
						</script></div></div><div id="imPageRow_5" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<!--<div id="imCell_10" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_10" bis_skin_checked="1"></div><div id="imCellStyleBorders_10" bis_skin_checked="1"></div><div id="imTextObject_54_10" bis_skin_checked="1">
							<div data-index="0" class="text-tab-content grid-prop current-tab " id="imTextObject_54_10_tab0" style="opacity: 1; " role="tabpanel" tabindex="0" bis_skin_checked="1">
								<div class="text-inner" bis_skin_checked="1">
									<div bis_skin_checked="1"><hr></div><div bis_skin_checked="1"><span class="fs14lh1-5">⚠️ <span class="cf1"> IMPORTANTE ⚠️</span></span></div> <div bis_skin_checked="1"><span class="fs14lh1-5 cf1">Compartir su cuenta será detectado automáticamente por nuestro sistema, resultando en SUSPENSIÓN INMEDIATA sin derecho a reembolso ni reclamos. ¡NO ARRIESGUE SU INVERSIÓN!</span></div><div bis_skin_checked="1"><span class="fs14lh1-5 cf1"><br></span></div><div bis_skin_checked="1"><div bis_skin_checked="1"><strong class="fs12lh1-5">Actualización Abril v1.8-2025 - MiPatente.cl</strong></div><div bis_skin_checked="1"><br></div></div>
								</div>
							</div>
						
						</div>
						</div><div id="imPageRow_6" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_7" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_23" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_23" bis_skin_checked="1"></div><div id="imCellStyleBorders_23" bis_skin_checked="1"></div><div id="imObjectTitle_54_23" bis_skin_checked="1"><span id="imObjectTitle_54_23_text">¡¡¡ IMPORTANTE !!!</span></div></div><div id="imCell_22" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_22" bis_skin_checked="1"></div><div id="imCellStyleBorders_22" bis_skin_checked="1"></div><div id="imTextObject_54_22" bis_skin_checked="1">
							<div data-index="0" class="text-tab-content grid-prop current-tab " id="imTextObject_54_22_tab0" style="opacity: 1; " role="tabpanel" tabindex="0" bis_skin_checked="1">
								<div class="text-inner" bis_skin_checked="1">
									<div class="imTACenter" bis_skin_checked="1"><span class="fs20lh1-5 cf1"><b>DEBES VER ....</b></span></div><div class="imTACenter" bis_skin_checked="1"><br></div><div class="imTACenter" bis_skin_checked="1"><b class="fs18lh1-5 cf2"><span><a href="https://mipatente.cl/guia-completa.php" class="imCssLink" onclick="return x5engine.utils.location(&#39;guia-completa.php&#39;, null, false)">Guía Configuracion y grabado para Máquina color blanco</a></span> </b><b class="fs18lh1-5 cf3"> </b></div><div class="imTACenter" bis_skin_checked="1"><br></div><div class="imTACenter" bis_skin_checked="1"><b><span class="fs16lh1-5"><a href="https://mipatente.cl/guia-maquina-negra-.php" class="imCssLink" onclick="return x5engine.utils.location(&#39;guia-maquina-negra-.php&#39;, null, false)">GUÍA CONFIGURACION PARA MAQUINA COLOR NEGRO </a></span></b></div>
								</div>
							</div>
						
						</div>
						</div><div id="imPageRow_8" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_60" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_60" bis_skin_checked="1"></div><div id="imCellStyleBorders_60" bis_skin_checked="1"></div><!-- Textillate v.5 --><!--<div id="pluginAppObj_54_60" bis_skin_checked="1"><div id="textillateContainer_pluginAppObj_54_60" bis_skin_checked="1">
						    <!--<div id="textillate_pluginAppObj_54_60" bis_skin_checked="1" style="font-size: 18.996pt;">No te quedes sin Suministros <span style="display: none;"> ##br## </span>Papel y Ácido en MiPatente.cl</div>
						</div>
						
						<script>
						    init_pluginAppObj_54_60("No te quedes sin Suministros &lt;br /&gt;Papel y Ácido en MiPatente.cl");
						</script></div></div><div id="imPageRow_9" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_62" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_62" bis_skin_checked="1"></div><div id="imCellStyleBorders_62" bis_skin_checked="1"></div><div id="imObjectImage_54_62" bis_skin_checked="1"><div id="imObjectImage_54_62_container" bis_skin_checked="1"><a href="https://mipatente.cl/product/?pasta-para-grabado-de-patentes"><img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/ACIDO-PARA-GRABADOS.webp" width="278" height="318">
						</a></div></div></div><div id="imCell_61" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_61" bis_skin_checked="1"></div><div id="imCellStyleBorders_61" bis_skin_checked="1"></div><div id="imObjectImage_54_61" bis_skin_checked="1"><div id="imObjectImage_54_61_container" bis_skin_checked="1"><a href="https://mipatente.cl/product/?papel-grabado-de-patentes"><img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/papel-para-grabado-de-patentes-1.webp" width="280" height="320">
						</a></div></div></div><div id="imPageRow_10" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_11" class="imPageRow" bis_skin_checked="1">
						
						</div>
						
					</main>
					<div id="imFooterBg" bis_skin_checked="1"></div>
					<footer id="imFooter">
						<!-- FooterObjects -->
					</footer>
				</div>
				<span class="screen-reader-only-even-focused" style="bottom: 0;"><a href="https://mipatente.cl/app-grabados-1.8-.php#imGoToCont" title="Lea esta página de nuevo">Regreso al contenido</a></span>
			</div>
		</div>
		<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5cart.js.descarga"></script>
		<noscript class="imNoScript"><div class="alert alert-red">Para utilizar este sitio tienes que habilitar JavaScript.</div></noscript>
	

<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/modernizr-custom.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5engine.deferrable.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/l10n.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5cartengine.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5settings.js.descarga"></script><div id="media-query-to-js" bis_skin_checked="1" style=""></div>
<script>
function imprimirSeccion() {
    const contenido = document.getElementById('area-a-imprimir').innerHTML;
    const ventana = window.open('', '', 'height=600,width=800');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write('</head><body>');
    ventana.document.write(contenido);
    ventana.document.write('
<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</body></html>

</script>

<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</body></html>