
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patente 4.3cm x 1cm Móvil Compacto</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 10px;
        }
        .container {
            background: #fff;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
            max-width: 100%;
            margin: auto;
        }
        input, button {
            width: 100%;
            padding: 12px;
            font-size: 18px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        canvas {
            display: block;
            margin: 0 auto 10px auto;
            border: 1px solid #ddd;
            max-width: 100%;
        }
    </style>
</head>
<body>
<div class="container">
    <h3 style="text-align:center;">Imprimir Patente</h3>
    <input type="text" id="textInput" maxlength="6" placeholder="ABC123" oninput="updateCanvas()" style="text-transform: uppercase;">
    <canvas id="previewCanvas" width="1000" height="160"></canvas>
    <button onclick="imprimirPatente()">Imprimir</button>
</div>

<script>
const canvas = document.getElementById('previewCanvas');
const ctx = canvas.getContext('2d');

function updateCanvas() {
    const text = document.getElementById('textInput').value.toUpperCase();
    ctx.fillStyle = 'white';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = '#333';
    ctx.font = '150px monospace';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(text, canvas.width / 2, canvas.height / 2);
}

function imprimirPatente() {
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = 1000;
    tempCanvas.height = 160;
    const tctx = tempCanvas.getContext('2d');

    tctx.fillStyle = 'white';
    tctx.fillRect(0, 0, tempCanvas.width, tempCanvas.height);

    tctx.fillStyle = '#333';
    tctx.translate(tempCanvas.width, 0);
    tctx.scale(-1, 1);
    tctx.font = '150px monospace';
    tctx.textAlign = 'center';
    tctx.textBaseline = 'middle';

    const text = document.getElementById('textInput').value.toUpperCase();
    tctx.fillText(text, tempCanvas.width / 2, tempCanvas.height / 2);

    const dataUrl = tempCanvas.toDataURL('image/png');
    const w = window.open('', '_blank');
    w.document.write('<html><head><title>Imprimir</title><style>body{margin:0;} img{width:4.3cm;height:1cm;display:block;margin:auto;}</style></head><body>');
    w.document.write('<img src="' + dataUrl + '"/>');
    w.document.write('</body></html>');
    w.document.close();
    w.focus();
    w.onload = () => w.print();
}

updateCanvas();
</script>
</body>
</html>
