
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Patente Personalizable Alta Calidad</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        canvas {
            border: 1px solid #ccc;
            display: block;
            margin: 10px auto;
        }
        input, select, button {
            display: block;
            width: 100%;
            margin-bottom: 10px;
            padding: 10px;
            font-size: 16px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Generador de Patentes Personalizado (Alta Calidad)</h2>
    <input type="text" id="textInput" maxlength="6" placeholder="Ej: ABC123" oninput="updateCanvas()" style="text-transform: uppercase;">

    <label for="fontSizeInput">Tamaño de fuente (60-150):</label>
    <input type="number" id="fontSizeInput" value="90" min="60" max="150" onchange="updateCanvas()">

    <label for="fontFamilyInput">Fuente:</label>
    <select id="fontFamilyInput" onchange="updateCanvas()">
        <option value="Arial">Arial</option>
        <option value="Poppins">Poppins</option>
        <option value="Monospace">Monospace</option>
        <option value="Roboto">Roboto</option>
        <option value="Times">Times</option>
    </select>

    <canvas id="previewCanvas" width="420" height="280"></canvas>

    <button onclick="imprimirPatenteAltaCalidad()">Imprimir Patente (50mm x 20mm)</button>
</div>

<script>
const canvas = document.getElementById('previewCanvas');
const ctx = canvas.getContext('2d');

function updateCanvas() {
    const text = document.getElementById('textInput').value.toUpperCase();
    const fontSize = document.getElementById('fontSizeInput').value;
    const fontFamily = document.getElementById('fontFamilyInput').value;

    ctx.fillStyle = 'white';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = 'black';
    ctx.font = fontSize + 'px ' + fontFamily + ', sans-serif';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(text, canvas.width / 2, canvas.height / 2);
}

function imprimirPatenteAltaCalidad() {
    const text = document.getElementById('textInput').value.toUpperCase();
    const fontSize = document.getElementById('fontSizeInput').value * 10; // escala para alta res
    const fontFamily = document.getElementById('fontFamilyInput').value;

    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = 1000;
    tempCanvas.height = 400;
    const ctxTemp = tempCanvas.getContext('2d');

    ctxTemp.fillStyle = 'white';
    ctxTemp.fillRect(0, 0, tempCanvas.width, tempCanvas.height);
    ctxTemp.fillStyle = 'black';
    ctxTemp.translate(tempCanvas.width, 0);
    ctxTemp.scale(-1, 1);
    ctxTemp.font = fontSize + 'px ' + fontFamily + ', sans-serif';
    ctxTemp.textAlign = 'center';
    ctxTemp.textBaseline = 'middle';
    ctxTemp.fillText(text, tempCanvas.width / 2, tempCanvas.height / 2);

    const dataUrl = tempCanvas.toDataURL('image/png');

    const win = window.open('', '_blank');
    win.document.write('<html><head><title>Imprimir Patente</title>');
    win.document.write('<style>body{margin:0;text-align:center;} img{display:block;margin:auto;width:50mm;height:20mm;}</style>');
    win.document.write('</head><body>');
    win.document.write('<img src="' + dataUrl + '"/>');
    win.document.write('</body></html>');
    win.document.close();
    win.focus();
    win.onload = () => win.print();
}

updateCanvas();
</script>

</body>
</html>
