<!DOCTYPE html>

<html lang="es">
<head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Aplicación Responsiva</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&amp;display=swap" rel="stylesheet"/>
<style>
        :root {
            --primary-color: #00c897;
            --secondary-color: #1d2d44;
            --accent-color: #f48c06;
            --text-color: #ffffff;
            --border-radius: 8px;
            --shadow-color: rgba(0, 0, 0, 0.2);
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, #1d2d44 0%, #0a1a30 100%);
            color: var(--text-color);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 2rem;
        }

        .input-group {
            display: flex;
            flex-direction: column;
            gap: 15px;
            align-items: center;
        }

        .input-group input, .input-group select {
            padding: 10px;
            border-radius: var(--border-radius);
            border: none;
            width: 80%;
            max-width: 400px;
        }

        .buttons {
            display: flex;
            justify-content: center;
            gap: 10px;
        }

        .buttons button {
            padding: 10px 20px;
            border-radius: var(--border-radius);
            border: none;
            background: var(--primary-color);
            color: var(--text-color);
            cursor: pointer;
            font-size: 1rem;
        }

        .buttons button:hover {
            background: var(--accent-color);
        }

        @media (max-width: 768px) {
            .header h1 {
                font-size: 1.5rem;
            }

            .input-group input, .input-group select {
                width: 100%;
            }
        }

        @media (max-width: 480px) {
            .header h1 {
                font-size: 1.2rem;
            }

            .buttons button {
                font-size: 0.9rem;
            }
        }
    </style>
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>
</head>
<body>
<!-- <div class="container">
        <div class="header">
            <h1>Aplicación Responsiva</h1>
        </div>
        
        </div>
    </div>-->
<label>Cargar logo:</label>
<div bis_skin_checked="1" class="file-input-wrapper">
<input accept="image/*" id="logoInput" type="file"/>
</div>

<div bis_skin_checked="1">
<label>Logos:</label>
<select id="jpgLogoSelect" onchange="handleJpgLogoSelect()">
<option value="">Seleccionar</option>
<option value="ALFA ROMEO.jpg">ALFA ROMEO</option>
<option value="Audi.jpg">Audi</option>
<option value="Audi2.jpg">Audi2</option>
<option value="Baic group.jpg">Baic Group</option>
<option value="BMW.jpg">BMW</option>
<option value="Byd.jpg">Byd</option>
<option value="brilliance.jpg">Brilliance</option>
<option value="Changan.jpg">Changan</option>
<option value="chery.jpg">Chery</option>
<option value="Cherry.jpg">Cherry</option>
<option value="Chevrolet.jpg">Chevrolet</option>
<option value="Citroen.jpg">Citroen</option>
<option value="Daewoo.jpg">Daewoo</option>
<option value="Dfsk.jpg">Dfsk</option>
<option value="Donge.jpg">Donge</option>
<option value="dongfeng.jpg">dongfeng</option>
<option value="Faw.jpg">Faw</option>
<option value="FIAT2.jpg">FIAT1</option>
<option value="FIAT.jpg">FIAT2</option>
<option value="Ford.jpg">Ford</option>
<option value="foton.jpg">Foton.jpg</option>
<option value="Geely.jpg">Geely</option>
<option value="Great Wall.jpg">Great Wall</option>
<option value="Honda.jpg">Honda</option>
<option value="honda2.jpg">honda2</option>
<option value="Hyundai Motor.jpg">Hyundai Motor</option>
<option value="Hyundai.jpg">Hyundai</option>
<option value="isuzu.jpg">Isuzu</option>
<option value="JAC motor.jpg">JAC motor</option>
<option value="Jaguar.jpg">Jaguar</option>
<option value="Jeep.jpg">Jeep</option>
<option value="JMC1.jpg">JMC1</option>
<option value="KIA1.jpg">KIA1</option>
<option value="KIA2.jpg">KIA2</option>
<option value="Land Rover.jpg">Land Rover</option>
<option value="Lexus.jpg">Lexus</option>
<option value="Lexus2.jpg">Lexus2</option>
<option value="lifan.jpg">Lifan</option>
<option value="maxus.jpeg">Maxus</option>
<option value="mahindra.jpg">Mahindra</option>
<option value="Mazda.jpg">Mazda</option>
<option value="Mercedes Benz.jpg">Mercedes Benz</option>
<option value="MG.jpg">MG</option>
<option value="Mini.jpg">Mini</option>
<option value="Mitsubishi.jpg">Mitsubishi</option>
<option value="Nissan.jpg">Nissan</option>
<option value="NISSAN2.jpg">NISSAN2</option>
<option value="Peugeot.jpg">Peugeot</option>
<option value="Porsche.jpg">Porsche</option>
<option value="Porsche2.jpg">Porsche2</option>
<option value="Renault.jpg">Renault</option>
<option value="Renault2.jpg">Renault2</option>
<option value="Scania.jpg">Scania</option>
<option value="Scania2.jpg">Scania2</option>
<option value="Seat.jpg">Seat</option>
<option value="SEAT2.jpg">SEAT2</option>
<option value="Skoda.jpg">Skoda</option>
<option value="SsangYong.jpg">SsangYong</option>
<option value="SsangYong2.jpg">SsangYong2</option>
<option value="Subaru.jpg">Subaru</option>
<option value="Subaru2.jpg">Subaru2</option>
<option value="Suzuki.jpg">Suzuki</option>
<option value="Suzuki2.jpg">Suzuki2</option>
<option value="TESLA.jpg">TESLA</option>
<option value="Toyota.jpg">Toyota</option>
<option value="Opel.jpg">Opel</option>
<option value="Volkswagen.jpg">Volkswagen</option>
<option value="Volkswagen2.jpg">Volkswagen2</option>
<option value="Volvo.jpg">Volvo</option>
<option value="Volvo2.jpg">Volvo2</option>
</select>
</div>


<div bis_skin_checked="1" class="input-group">
<div bis_skin_checked="1" class="new-patent-input">
<label for="textInput">Patente:</label>
<input id="textInput" maxlength="6" placeholder="6 caracteres" style="text-transform: uppercase" type="text"/>
</div>
<div bis_skin_checked="1" class="mode-buttons">
<button class="mode-button active" data-mode="280" onclick="selectMode('280')">Logos</button>
<button class="mode-button" data-mode="200" onclick="selectMode('200')">Letras</button>
<button class="mode-button" data-mode="auto" onclick="selectMode('auto')">Ecomi</button>
</div>
<div bis_skin_checked="1" class="format-controls">
<button class="toggle-button" id="formatToggle" onclick="toggleFormat()">Formato: OFF</button>
<select id="formatTypeSelect" onchange="saveSettings(); updateCanvas()" style="display: none;">
<option value="1">AB-CD-EF</option>
<option value="2">AB·CD·EF</option>
<option value="3">AB·CD-EF</option>
<option value="4">AB-CD·EF</option>
</select>
</div>
</div>
<div bis_skin_checked="1" class="preview-area">
<canvas height="280" id="previewCanvas" width="420"></canvas>
<div bis_skin_checked="1" class="font-controls">
<div bis_skin_checked="1">
<label>Estilos:</label>
<select id="styleSelect" onchange="updateCanvas()">
<option selected="" value="normal">Normal</option>
<option value="bold">Negritas</option>
</select>
</div>
<div bis_skin_checked="1">
<label>Fuentes:</label>
<select id="fontSelect" onchange="saveSettings(); updateCanvas()">
<option value="Roboto Condensed">Roboto Condensed</option>
<option value="monospace">Monospace</option>
<option value="FE-FONT">FE-FONT</option>
<option value="serif">Serif</option>
<option value="Arial">Arial</option>
<option value="Times">Times</option>
<option value="Poppins">Poppins</option>
</select>
</div>
<div bis_skin_checked="1" class="font-size-buttons">
<label>Tamaño:</label>
<span id="fontSizeValue">95</span>
<button onclick="changeFontSize(5)" type="button">+</button>
<button onclick="changeFontSize(-5)" type="button">-</button>
</div>
</div>
<div bis_skin_checked="1" class="controls-container">
<div bis_skin_checked="1" class="control-group">
<label for="spacingSlider">Espaciado</label>
<input id="spacingSlider" max="150" min="0" type="range" value="50"/>
</div>
<div bis_skin_checked="1" class="control-group">
<label for="sizeSlider">Tamaño Logo</label>
<input id="sizeSlider" max="100" min="20" type="range" value="45"/>
</div>
</div>
</div>
<button onclick="imprimirCanvas()">Descargar Patente</button>
<!--<button class="history-button" onclick="showPatentHistory()">Ver Registro de Patentes</button>-->
<div bis_skin_checked="1" id="patentHistoryWindow">
<h2>Registro de Patentes</h2>
<ul id="patentList"></ul>
<button class="close-button" onclick="closePatentHistory()">Cerrar</button>
</div>

<h1>Tu IP Actual:</h1>
<p id="ip-address">190.45.25.37</p>
<script>
						       // Función para obtener la IP
						       async function getIP() {
						           try {
						               const response = await fetch('https://api.ipify.org?format=json');
						               if (!response.ok) {
						                   throw new Error('Error en la solicitud: ' + response.status);
						               }
						               const data = await response.json();
						               document.getElementById('ip-address').textContent = data.ip;
						           } catch (error) {
						               document.getElementById('ip-address').textContent = 'Error al obtener la IP';
						               console.error('Detalles del error:', error);
						           }
						       }
						
						       // Ejecutar la función al cargar la página
						       getIP();
						   
document.addEventListener("DOMContentLoaded", function() {
  const btn = document.getElementById("descargar-patente");
  if (btn) {
    btn.addEventListener("click", function (e) {
      e.preventDefault();
      const ventana = window.open("", "Etiqueta", "width=800,height=600");
      ventana.document.write(document.documentElement.innerHTML);
      ventana.document.close();
      ventana.focus();
      ventana.print();
    });
  }
});
</script>
<div bis_skin_checked="1" class="imPageRow" id="imPageRow_4">
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
function imprimirSeccion() {
    const contenido = document.getElementById('area-a-imprimir').innerHTML;
    const ventana = window.open('', '', 'height=600,width=800');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write(contenido);
    ventana.document.write('
<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</body></html>

<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>


<!DOCTYPE html>

<!-- saved from url=(0042)https://mipatente.cl/app-grabados-1.8-.php -->
<html class="svg canvas video supports no-touchevents fullscreen cssanimations csstransforms csstransforms3d csstransitions k-webkit k-webkit136" dir="ltr" lang="es-ES" prefix="og: http://ogp.me/ns#"><script id="eppiocemhmnlbhjplcgkofciiegomcon" src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/content/location/location.js"></script><script src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/libs/extend-native-history-api.js"></script><script src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/libs/requests.js"></script><head><meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
<title>Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile.</title>
<!--[if IE]><meta http-equiv="ImageToolbar" content="False" /><![endif]-->
<meta content="MiPatente.cl" name="author"/>
<meta content="Incomedia WebSite X5 Pro 2025.1.4 - www.websitex5.com" name="generator"/>
<meta content="Con esta aplicación podrás generar tus plantillas para grabar vidrios logos y patentes con marcas de vehículos más usadas en Chile, Facil y rapido " name="description"/>
<meta content="Aplicacion para patentes Gratis, sofware para crear plantillas de patentes gratis, Herramienta para crear plantillas de patentes gratis, aplicacion patentes con logos gratis, generador de plantillas de patentes online gratis, diseña patentes con logos, sofware para impresion de patentes, programa para imprimir patentes con logos, programa para generar plantillas con logos de autos gratis, programa para patentes  " name="keywords"/>
<meta content="es" property="og:locale"/>
<meta content="website" property="og:type"/>
<meta content="https://mipatente.cl/app-grabados-1.8-.php" property="og:url"/>
<meta content="Aplicacion online para generar plantillas para grabado de patentes" property="og:title"/>
<meta content="MiPatente.cl – Pintado y Grabados de Patentes en Chile." property="og:site_name"/>
<meta content="Con esta aplicación podrás generar tus plantillas para grabar vidrios logos y patentes con marcas de vehículos más usadas en Chile, Facil y rapido " property="og:description"/>
<meta content="https://mipatente.cl/favImage.png" property="og:image"/>
<meta content="image/png" property="og:image:type"/>
<meta content="868" property="og:image:width"/>
<meta content="233" property="og:image:height"/>
<meta content="https://mipatente.cl/favImage_small.png" property="og:image"/>
<meta content="image/png" property="og:image:type"/>
<meta content="400" property="og:image:width"/>
<meta content="107" property="og:image:height"/>
<meta content="summary_large_image" name="twitter:card"/>
<meta content="width=device-width, initial-scale=1" name="viewport"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/reset.css" media="screen,print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/print.css" media="print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/style.css" media="screen,print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom.css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/animate.min.css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(1).css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus.css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(2).css" media="screen, print" rel="stylesheet"/><link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/static.css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/custom(3).css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus(1).css" media="screen, print" rel="stylesheet"/>
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/app-grabados-1.8-.css" media="screen,print" rel="stylesheet"/>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.js.descarga"></script><script bis_use="true" charset="utf-8" data-bis-config='["facebook.com/","twitter.com/","youtube-nocookie.com/embed/","//vk.com/","//www.vk.com/","linkedin.com/","//www.linkedin.com/","//instagram.com/","//www.instagram.com/","//www.google.com/recaptcha/api2/","//hangouts.google.com/webchat/","//www.google.com/calendar/","//www.google.com/maps/embed","spotify.com/","soundcloud.com/","//player.vimeo.com/","//disqus.com/","//tgwidget.com/","//js.driftt.com/","friends2follow.com","/widget","login","//video.bigmir.net/","blogger.com","//smartlock.google.com/","//keep.google.com/","/web.tolstoycomments.com/","moz-extension://","chrome-extension://","/auth/","//analytics.google.com/","adclarity.com","paddle.com/checkout","hcaptcha.com","recaptcha.net","2captcha.com","accounts.google.com","www.google.com/shopping/customerreviews","buy.tinypass.com","gstatic.com","secureir.ebaystatic.com","docs.google.com","contacts.google.com","github.com","mail.google.com","chat.google.com","audio.xpleer.com","keepa.com","static.xx.fbcdn.net","sas.selleramp.com","1plus1.video","console.googletagservices.com","//lnkd.demdex.net/","//radar.cedexis.com/","//li.protechts.net/","challenges.cloudflare.com/","ogs.google.com"]' src="chrome-extension://eppiocemhmnlbhjplcgkofciiegomcon/executors/traffic.js" type="text/javascript"></script>
<script data-files-version="2025-1-4-0" src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5engine.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.lettering.min.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/jquery.textillate.min.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main(1).js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus_no16hoiq.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/main(2).js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/init.js.descarga"></script>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/cartStatus.js.descarga"></script>
<script>
			window.onload = function(){ checkBrowserCompatibility('El Explorador que estás usando no es compatible con las funciones requeridas para mostrar este Sitio web.','El Navegador que estás utilizando podría no ser compatible con las funciones requeridas para poder ver este Sitio web.','[1]Actualiza tu explorador [/1] o [2]continuar de todos modos[/2].','http://outdatedbrowser.com/'); };
			x5engine.utils.currentPagePath = 'app-grabados-1.8-.php';
		</script>
<link href="https://mipatente.cl/favicon.png?2025-1-4-0-638830202928842429" rel="icon" type="image/png"/>
<link href="https://mipatente.cl/blog/x5feed.php" rel="alternate" title="" type="application/rss+xml"/>
<link href="https://mipatente.cl/aplicacion-para-grabado-de-vidrios.php" rel="canonical"/>
<!-- Google tag (gtag.js) -->
<script async="" src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/js"></script>
<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());
		
		  gtag('config', 'G-M8JCKMD4W9');
		</script>
<!-- Global site tag (gtag.js) - Google Analytics --><script async="" src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/js"></script><script>window.dataLayer=window.dataLayer||[];function gtag(){dataLayer.push(arguments);}gtag('js', new Date());gtag('config', 'G-M8JCKMD4W9');</script>
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>
</head>
<body __processed_91988f31-03bd-4eff-bef2-992fdd4da98e__="true" bis_register="W3sibWFzdGVyIjp0cnVlLCJleHRlbnNpb25JZCI6ImVwcGlvY2VtaG1ubGJoanBsY2drb2ZjaWllZ29tY29uIiwiYWRibG9ja2VyU3RhdHVzIjp7IkRJU1BMQVkiOiJkaXNhYmxlZCIsIkZBQ0VCT09LIjoiZGlzYWJsZWQiLCJUV0lUVEVSIjoiZGlzYWJsZWQiLCJSRURESVQiOiJkaXNhYmxlZCIsIlBJTlRFUkVTVCI6ImRpc2FibGVkIiwiSU5TVEFHUkFNIjoiZGlzYWJsZWQiLCJMSU5LRURJTiI6ImRpc2FibGVkIiwiQ09ORklHIjoiZGlzYWJsZWQifSwidmVyc2lvbiI6IjIuMC4yMiIsInNjb3JlIjoyMDAyMn1d">
<!--<div id="imPageExtContainer" bis_skin_checked="1">
			<div id="imPageIntContainer" bis_skin_checked="1">
				<a class="screen-reader-only-even-focused" href="https://mipatente.cl/app-grabados-1.8-.php#imGoToCont" title="Salta el menu principal">Vaya al Contenido</a>
				<div id="imHeaderBg" bis_skin_checked="1"></div>
				<div id="imPage" bis_skin_checked="1">
					<header id="imHeader" style="">
						<h1 class="imHidden">Aplicacion online para generar plantillas para grabado de patentes - MiPatente.cl – Pintado y Grabados de Patentes en Chile.</h1>
						<!-- HeaderObjects -->

<div bis_skin_checked="1" id="imStickyBarContainer" style="margin-top: 0px; left: 0px; bottom: auto; z-index: 10302; transform: translateZ(0px); top: 0px; visibility: visible; overflow: visible;">
<div bis_skin_checked="1" id="imStickyBarGraphics"></div>
<div bis_skin_checked="1" id="imStickyBar">
<!-- StickyBarObjects -->
</div>
</div>
<div bis_skin_checked="1" id="imSideBar">
<!-- SideBarObjects -->
</div>
<!--<div id="imContentGraphics" bis_skin_checked="1"></div>
					<main id="imContent">
						<a id="imGoToCont"></a>
						<div id="imPageRow_1" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_2" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_59" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_59" bis_skin_checked="1"><div style="position: relative; height: 100%;" bis_skin_checked="1"><div id="imCellStyleGraphicsC_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsT_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsTL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsTR_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsR_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsB_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsBL_59" bis_skin_checked="1"></div><div id="imCellStyleGraphicsBR_59" bis_skin_checked="1"></div></div></div><div id="imCellStyleBorders_59" bis_skin_checked="1"></div><div id="imHTMLObject_54_59" class="imHTMLObject" style="text-align: center; width: 100%; overflow: hidden;" bis_skin_checked="1">
						
						
						    
						    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
						    <title>Generador de Patentes - MiPatente.cl</title>
						    <!-- Cargar fuentes de Google Fonts con pesos bold -->
<link href="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/css2" rel="stylesheet"/>
<style>
						        :root {
						            --primary-color: #00c897;
						            --secondary-color: #1d2d44;
						            --accent-color: #f48c06;
						            --history-button-color: #007bff;
						            --history-button-accent: #0056b3;
						            --text-color: #ffffff;
						            --border-radius: 8px;
						            --shadow-color: rgba(0, 0, 0, 0.2);
						            --input-height: 60px;
						            --file-input-height: 30px;
						        }
						
						        @font-face {
						            font-family: 'FE-FONT';
						            src: url('/FE-FONT.woff2') format('woff2'),
						                 url('/FE-FONT.ttf') format('truetype');
						            font-weight: normal;
						            font-style: normal;
						        }
						
						        body {
						            font-family: 'Poppins', sans-serif;
						            max-width: 1200px;
						            margin: 0 auto;
						            padding: 20px;
						            background: linear-gradient(135deg, #1d2d44 0%, #0a1a30 100%);
						            color: var(--text-color);
						            min-height: 100vh;
						            -webkit-font-smoothing: antialiased;
						            font-size: 16px;
						        }
						
						        .container {
						            background: rgba(29, 45, 68, 0.95);
						            padding: 30px;
						            border-radius: var(--border-radius);
						            box-shadow: 0 10px 30px var(--shadow-color);
						            border: 1px solid rgba(255, 255, 255, 0.1);
						        }
						
						        h1 {
						            color: #ffffff;
						            font-size: 1.8rem;
						            text-align: center;
						            margin-bottom: 1rem;
						            font-weight: 600;
						            font-family: 'Montserrat', sans-serif;
						            letter-spacing: 2px;
						        }
						
						        .preview-area {
						            border: 2px solid var(--primary-color);
						            padding: 20px;
						            margin: 15px 0;
						            background: rgba(255, 255, 255, 0.05);
						            text-align: center;
						            border-radius: var(--border-radius);
						            transition: transform 0.3s ease, box-shadow 0.3s ease;
						        }
						
						        .preview-area:hover {
						            transform: scale(1.02);
						            box-shadow: 0 8px 20px var(--shadow-color);
						        }
						
						        canvas {
						            max-width: 100%;
						            background: rgba(255, 255, 255, 0.1);
						            border-radius: var(--border-radius);
						            border: 5px solid var(--primary-color);
						            box-shadow: 0 6px 15px var(--shadow-color);
						        }
						
						        .input-group {
						            margin-bottom: 15px;
						            max-width: 350px;
						            margin-left: auto;
						            margin-right: auto;
						            display: flex;
						            flex-direction: column;
						            gap: 8px;
						        }
						
						        .logo-controls {
						            display: flex;
						            flex-direction: column;
						            gap: 8px;
						            margin-bottom: 10px;
						            max-width: 350px;
						            margin-left: auto;
						            margin-right: auto;
						        }
						
						        .font-controls {
						            display: flex;
						            flex-direction: row;
						            gap: 8px;
						            margin: 10px auto;
						            max-width: 350px;
						            align-items: center;
						        }
						
						        .font-controls > div {
						            flex: 1;
						            min-width: 0;
						        }
						
						        .font-size-buttons {
						            display: flex;
						            flex-direction: column;
						            gap: 5px;
						            align-items: center;
						            min-width: 60px;
						        }
						
						        .font-size-buttons button {
						            width: 40px;
						            height: 40px;
						            padding: 0;
						            font-size: 1.2rem;
						            min-width: 0;
						            margin: 0;
						            border-radius: 8px;
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            color: var(--text-color);
						            border: none;
						            cursor: pointer;
						            transition: all 0.3s ease;
						        }
						
						        .font-size-buttons button:hover {
						            transform: translateY(-2px);
						            box-shadow: 0 6px 20px var(--shadow-color);
						        }
						
						        .font-size-buttons label {
						            font-size: 1.1rem;
						            margin-bottom: 5px;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						            white-space: nowrap;
						        }
						
						        #fontSizeValue {
						            font-size: 1.1rem;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						            margin: 0 5px;
						            min-width: 40px;
						            text-align: center;
						        }
						
						        .new-patent-input {
						            max-width: 200px;
						            margin: 0 auto;
						            padding: 10px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						        }
						
						        .new-patent-input label {
						            font-size: 1.2rem;
						            text-align: center;
						            margin-bottom: 8px;
						        }
						
						        #textInput {
						            font-family: 'Poppins', sans-serif;
						            font-size: 2rem;
						            text-align: center;
						            height: 50px;
						            width: 100%;
						            padding: 5px;
						            border: none;
						            background: transparent;
						            color: var(--text-color);
						        }
						
						        .mode-buttons {
						            display: flex;
						            gap: 5px;
						            justify-content: center;
						            margin: 10px 0;
						        }
						
						        .mode-button {
						            width: 80px;
						            height: 40px;
						            padding: 0;
						            font-size: 1rem;
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            cursor: pointer;
						            transition: all 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        .mode-button.active {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            border: none;
						            box-shadow: 0 4px 15px var(--shadow-color);
						        }
						
						        .mode-button:hover:not(.active) {
						            background: rgba(255, 255, 255, 0.2);
						        }
						
						        .toggle-button {
						            width: 120px;
						            height: 40px;
						            padding: 0;
						            font-size: 1rem;
						            border-radius: var(--border-radius);
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            cursor: pointer;
						            transition: all 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        .toggle-button.active {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            border: none;
						            box-shadow: 0 4px 15px var(--shadow-color);
						        }
						
						        .toggle-button:hover:not(.active) {
						            background: rgba(255, 255, 255, 0.2);
						        }
						
						        .format-controls {
						            display: flex;
						            gap: 8px;
						            justify-content: center;
						            align-items: center;
						            margin: 10px 0;
						        }
						
						        .format-type-select {
						            width: 100px;
						            height: 35px;
						            padding: 0 8px;
						            font-size: 0.9rem;
						            border-radius: var(--border-radius);
						            background: var(--secondary-color);
						            color: #000000;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            font-family: 'Poppins', sans-serif;
						            transition: all 0.3s ease;
						            -webkit-appearance: none;
						            -moz-appearance: none;
						            appearance: none;
						            background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 8px center;
						            background-size: 18px;
						        }
						
						        .format-type-select:focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						            background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 8px center;
						        }
						
						        .format-type-select option {
						            background: var(--secondary-color);
						            color: #000000;
						        }
						
						        @media (max-width: 480px) {
						            #textInput {
						                font-size: 1.8rem;
						                height: 40px;
						                padding: 10px 5px;
						            }
						
						            :root {
						                --input-height: 50px;
						            }
						
						            h1 {
						                font-size: 1.3rem;
						            }
						
						            .font-controls {
						                flex-direction: row;
						                gap: 5px;
						            }
						
						            .font-controls label {
						                font-size: 1rem;
						            }
						
						            .font-controls select {
						                font-size: 1rem;
						                padding: 10px;
						            }
						
						            .input-group, .logo-controls, .font-controls {
						                max-width: 100%;
						            }
						
						            button {
						                max-width: 100%;
						            }
						
						            .new-patent-input label {
						                font-size: 1.5rem;
						            }
						
						            label {
						                font-size: 1.2rem;
						            }
						
						            input, select {
						                font-size: 1.2rem;
						                padding: 12px;
						            }
						
						            .mode-button {
						                width: 60px;
						                height: 35px;
						                font-size: 0.9rem;
						            }
						
						            .toggle-button {
						                width: 100px;
						                height: 35px;
						                font-size: 0.9rem;
						            }
						
						            .format-type-select {
						                width: 80px;
						                height: 30px;
						                font-size: 0.8rem;
						                padding: 0 6px;
						                background: var(--secondary-color) url('data:image/svg+xml;utf8,<svg fill="%23000000" height="20" viewBox="0 0 24 24" width="20" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 6px center;
						                background-size: 16px;
						            }
						        }
						
						        @media screen and (-webkit-min-device-pixel-ratio: 0) { 
						            #textInput {
						                font-size: 16px !important;
						            }
						            #textInput:focus {
						                font-size: 1.8rem !important;
						            }
						        }
						
						        @media (max-width: 768px) {
						            .container {
						                padding: 20px;
						                margin: 10px;
						                border-radius: 12px;
						            }
						
						            h1 {
						                font-size: 1.5rem;
						            }
						
						            .preview-area {
						                padding: 15px;
						            }
						
						            .controls-container {
						                flex-direction: column;
						                gap: 15px;
						            }
						
						            .control-group {
						                width: 100%;
						            }
						
						            .logo-controls {
						                flex-direction: column;
						                gap: 10px;
						                max-width: 100%;
						            }
						
						            .font-controls {
						                flex-direction: row;
						                gap: 8px;
						                max-width: 100%;
						            }
						
						            .input-group, .logo-controls, .font-controls {
						                max-width: 100%;
						            }
						
						            .new-patent-input {
						                max-width: 100%;
						            }
						
						            button {
						                max-width: 100%;
						            }
						
						            .new-patent-input label {
						                font-size: 1.5rem;
						            }
						
						            #textInput {
						                font-size: 2rem;
						            }
						
						            label {
						                font-size: 1.2rem;
						            }
						
						            input, select {
						                font-size: 1.2rem;
						                padding: 12px;
						            }
						        }
						
						        .controls-container {
						            display: flex;
						            justify-content: center;
						            gap: 20px;
						            margin-top: 15px;
						            background: rgba(255, 255, 255, 0.05);
						            padding: 15px;
						            border-radius: var(--border-radius);
						            max-width: 600px;
						            margin-left: auto;
						            margin-right: auto;
						        }
						
						        .control-group {
						            width: 180px;
						            text-align: center;
						        }
						
						        .control-group label {
						            font-size: 1rem;
						            margin-bottom: 8px;
						            color: var(--text-color);
						            font-weight: 600;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        label {
						            display: block;
						            margin-bottom: 8px;
						            font-weight: 600;
						            color: var(--text-color);
						            font-size: 1.1rem;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input, select {
						            width: 100%;
						            height: var(--input-height);
						            padding: 10px;
						            margin-bottom: 10px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            font-size: 1.1rem;
						            transition: all 0.3s ease;
						            background: rgba(255, 255, 255, 0.1);
						            box-shadow: inset 0 2px 6px var(--shadow-color);
						            color: var(--text-color);
						            font-family: 'Poppins', sans-serif;
						            line-height: 1;
						        }
						
						        #jpgLogoSelect, 
						        #logoInput {
						            border-radius: var(--border-radius);
						        }
						
						        select:not(.format-type-select) {
						            -webkit-appearance: none;
						            -moz-appearance: none;
						            appearance: none;
						            background: rgba(255, 255, 255, 0.1) url('data:image/svg+xml;utf8,<svg fill="%23ffffff" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 12px center;
						            background-size: 20px;
						        }
						
						        select:not(.format-type-select):focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						            background: rgba(255, 255, 255, 0.1) url('data:image/svg+xml;utf8,<svg fill="%23ffffff" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>') no-repeat right 12px center;
						        }
						
						        select:not(.format-type-select) option {
						            background: rgba(29, 45, 68, 0.95);
						            color: var(--text-color);
						        }
						
						        input[type="range"] {
						            padding: 0;
						            height: 8px;
						            accent-color: var(--accent-color);
						            -webkit-appearance: none;
						            background: rgba(255, 255, 255, 0.2);
						            border-radius: 4px;
						        }
						
						        input[type="range"]::-webkit-slider-thumb {
						            -webkit-appearance: none;
						            width: 20px;
						            height: 20px;
						            background: var(--accent-color);
						            border-radius: 50%;
						            border: 2px solid rgba(255, 255, 255, 0.3);
						            box-shadow: 0 2px 6px var(--shadow-color);
						        }
						
						        input[type="range"]::-moz-range-thumb {
						            width: 20px;
						            height: 20px;
						            background: var(--accent-color);
						            border-radius: 50%;
						            border: 2px solid rgba(255, 255, 255, 0.3);
						            box-shadow: 0 2px 6px var(--shadow-color);
						        }
						
						        input:focus, select:focus {
						            border-color: var(--primary-color);
						            box-shadow: 0 0 0 3px rgba(0, 200, 151, 0.3);
						            outline: none;
						        }
						
						        .file-input-wrapper {
						            margin-bottom: 10px;
						        }
						
						        input[type="file"] {
						            height: var(--file-input-height);
						            padding: 5px;
						            border: 1px solid rgba(255, 255, 255, 0.2);
						            border-radius: var(--border-radius);
						            font-size: 1rem;
						            background: rgba(255, 255, 255, 0.1);
						            color: var(--text-color);
						            line-height: 1;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input[type="file"]::-webkit-file-upload-button {
						            height: 100%;
						            background: var(--primary-color);
						            color: var(--text-color);
						            border: none;
						            padding: 5px 15px;
						            border-radius: 6px;
						            font-weight: 600;
						            font-size: 1rem;
						            transition: background 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        input[type="file"]::-webkit-file-upload-button:hover {
						            background: var(--accent-color);
						        }
						
						        input[type="file"]::file-selector-button {
						            height: 100%;
						            background: var(--primary-color);
						            color: var(--text-color);
						            border: none;
						            padding: 5px 15px;
						            border-radius: 6px;
						            font-weight: 600;
						            font-size: 1rem;
						            transition: background 0.3s ease;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        button {
						            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
						            color: var(--text-color);
						            padding: 14px 24px;
						            border: none;
						            border-radius: var(--border-radius);
						            cursor: pointer;
						            width: 100%;
						            font-size: 1.2rem;
						            font-weight: 600;
						            transition: all 0.3s ease;
						            box-shadow: 0 4px 15px var(--shadow-color);
						            max-width: 300px;
						            margin-left: auto;
						            margin-right: auto;
						            margin-bottom: 20px;
						            display: block;
						            font-family: 'Poppins', sans-serif;
						        }
						
						        button.history-button {
						            background: linear-gradient(45deg, var(--history-button-color), var(--history-button-accent));
						        }
						
						        button:hover {
						            transform: translateY(-2px);
						            box-shadow: 0 6px 20px var(--shadow-color);
						        }
						
						        .header-logo {
						            display: block;
						            margin: 0 auto 20px auto;
						            max-width: 200px;
						            height: auto;
						        }
						
						        #patentHistoryWindow {
						            display: none;
						            position: fixed;
						            top: 50%;
						            left: 50%;
						            transform: translate(-50%, -50%);
						            background: rgba(29, 45, 68, 0.95);
						            padding: 20px;
						            border-radius: var(--border-radius);
						            box-shadow: 0 10px 30px var(--shadow-color);
						            border: 1px solid rgba(255, 255, 255, 0.1);
						            max-width: 400px;
						            width: 90%;
						            max-height: 400px;
						            overflow-y: auto;
						            z-index: 1000;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar {
						            width: 12px;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar-thumb {
						            background: var(--primary-color);
						            border-radius: 6px;
						        }
						
						        #patentHistoryWindow::-webkit-scrollbar-track {
						            background: rgba(255, 255, 255, 0.1);
						        }
						
						        #patentHistoryWindow h2 {
						            font-size: 1.5rem;
						            margin-bottom: 15px;
						            text-align: center;
						        }
						
						        #patentList {
						            list-style: none;
						            padding: 0;
						            margin: 0;
						        }
						
						        #patentList li {
						            padding: 10px;
						            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
						            display: flex;
						            justify-content: space-between;
						            align-items: center;
						        }
						
						        #patentList li:last-child {
						            border-bottom: none;
						        }
						
						        .close-button {
						            background: var(--accent-color);
						            padding: 10px 20px;
						            margin-top: 15px;
						            max-width: 100px;
						        }
						    </style>
<!--<div class="container" bis_skin_checked="1">
						       <!-- <img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/logo2.webp" alt="Logo" class="header-logo">
						       
						  <h1>v1.8-2025</h1>-->
<div bis_skin_checked="1" class="input-group" id="logoSection" style="display: block;">
<div bis_skin_checked="1" class="logo-controls">
<div bis_skin_checked="1">
<!--<label>Cargar logo:</label>
						                    <div class="file-input-wrapper" bis_skin_checked="1">
						                        <input type="file" id="logoInput" accept="image/*">
						                    </div>
						                </div>-->
<!-- <div bis_skin_checked="1">
						                    <label>Logos:</label>
						                    <select id="jpgLogoSelect" onchange="handleJpgLogoSelect()">
						                        <option value="">Seleccionar</option>
						                        <option value="ALFA ROMEO.jpg">ALFA ROMEO</option>
						                        <option value="Audi.jpg">Audi</option>
						                        <option value="Audi2.jpg">Audi2</option>
						                        <option value="Baic group.jpg">Baic Group</option>                     
						                        <option value="BMW.jpg">BMW</option>
						                        <option value="Byd.jpg">Byd</option>
						                        <option value="brilliance.jpg">Brilliance</option>                  
						                        <option value="Changan.jpg">Changan</option>
						                        <option value="chery.jpg">Chery</option>
						                        <option value="Cherry.jpg">Cherry</option>                       
						                        <option value="Chevrolet.jpg">Chevrolet</option>
						                        <option value="Citroen.jpg">Citroen</option>
						                        <option value="Daewoo.jpg">Daewoo</option>
						                        <option value="Dfsk.jpg">Dfsk</option>                       
						                        <option value="Donge.jpg">Donge</option>
						                        <option value="dongfeng.jpg">dongfeng</option>                     
						                        <option value="Faw.jpg">Faw</option>                   
						                        <option value="FIAT2.jpg">FIAT1</option>
						                        <option value="FIAT.jpg">FIAT2</option>
						                        <option value="Ford.jpg">Ford</option>
						                        <option value="foton.jpg">Foton.jpg</option>
						                        <option value="Geely.jpg">Geely</option>
						                        <option value="Great Wall.jpg">Great Wall</option>
						                        <option value="Honda.jpg">Honda</option>
						                        <option value="honda2.jpg">honda2</option>
						                        <option value="Hyundai Motor.jpg">Hyundai Motor</option>
						                        <option value="Hyundai.jpg">Hyundai</option>
						                        <option value="isuzu.jpg">Isuzu</option>
						                        <option value="JAC motor.jpg">JAC motor</option>
						                        <option value="Jaguar.jpg">Jaguar</option>
						                        <option value="Jeep.jpg">Jeep</option>
						                        <option value="JMC1.jpg">JMC1</option>
						                        <option value="KIA1.jpg">KIA1</option>
						                        <option value="KIA2.jpg">KIA2</option>
						                        <option value="Land Rover.jpg">Land Rover</option>
						                        <option value="Lexus.jpg">Lexus</option>
						                        <option value="Lexus2.jpg">Lexus2</option>
						                        <option value="lifan.jpg">Lifan</option>
						                        <option value="maxus.jpeg">Maxus</option>
						                        <option value="mahindra.jpg">Mahindra</option>
						                        <option value="Mazda.jpg">Mazda</option>
						                        <option value="Mercedes Benz.jpg">Mercedes Benz</option>
						                        <option value="MG.jpg">MG</option>
						                        <option value="Mini.jpg">Mini</option>
						                        <option value="Mitsubishi.jpg">Mitsubishi</option>
						                        <option value="Nissan.jpg">Nissan</option>
						                        <option value="NISSAN2.jpg">NISSAN2</option>
						                        <option value="Peugeot.jpg">Peugeot</option>
						                        <option value="Porsche.jpg">Porsche</option>
						                        <option value="Porsche2.jpg">Porsche2</option>
						                        <option value="Renault.jpg">Renault</option>
						                        <option value="Renault2.jpg">Renault2</option>
						                        <option value="Scania.jpg">Scania</option>
						                        <option value="Scania2.jpg">Scania2</option>
						                        <option value="Seat.jpg">Seat</option>
						                        <option value="SEAT2.jpg">SEAT2</option>
						                        <option value="Skoda.jpg">Skoda</option>
						                        <option value="SsangYong.jpg">SsangYong</option>
						                        <option value="SsangYong2.jpg">SsangYong2</option>
						                        <option value="Subaru.jpg">Subaru</option>
						                        <option value="Subaru2.jpg">Subaru2</option>
						                        <option value="Suzuki.jpg">Suzuki</option>
						                        <option value="Suzuki2.jpg">Suzuki2</option>
						                        <option value="TESLA.jpg">TESLA</option>
						                        <option value="Toyota.jpg">Toyota</option>
						                        <option value="Opel.jpg">Opel</option>
						                        <option value="Volkswagen.jpg">Volkswagen</option>
						                        <option value="Volkswagen2.jpg">Volkswagen2</option>
						                        <option value="Volvo.jpg">Volvo</option>
						                        <option value="Volvo2.jpg">Volvo2</option>                                                                                                                       
						                    </select>
						                </div>
						            </div>
						        </div>-->
<div bis_skin_checked="1" class="input-group">
<!--<div class="new-patent-input" bis_skin_checked="1">
						               <!-- <label for="textInput">Patente:</label>
						                <input type="text" style="text-transform: uppercase" id="textInput" placeholder="6 caracteres" maxlength="6">
						            </div>
						            <!--<div class="mode-buttons" bis_skin_checked="1">
						                <button class="mode-button active" data-mode="280" onclick="selectMode(&#39;280&#39;)">Logos</button>
						                <button class="mode-button" data-mode="200" onclick="selectMode(&#39;200&#39;)">Letras</button>
						                <button class="mode-button" data-mode="auto" onclick="selectMode(&#39;auto&#39;)">Ecomi</button>
						            </div>
						            <div class="format-controls" bis_skin_checked="1">
						                <button class="toggle-button" id="formatToggle" onclick="toggleFormat()">Formato: OFF</button>
						                <select id="formatTypeSelect" onchange="saveSettings(); updateCanvas()" style="display: none;">
						                    <option value="1">AB-CD-EF</option>
						                    <option value="2">AB·CD·EF</option>
						                    <option value="3">AB·CD-EF</option>
						                    <option value="4">AB-CD·EF</option>
						                </select>
						            </div>
						        </div>
						        <div class="preview-area" bis_skin_checked="1">
						            <canvas id="previewCanvas" width="420" height="280"></canvas>
						            <div class="font-controls" bis_skin_checked="1">
						                <div bis_skin_checked="1">
						                    <label>Estilos:</label>
						                    <select id="styleSelect" onchange="updateCanvas()">
						                        <option value="normal" selected="">Normal</option>
						                        <option value="bold">Negritas</option>
						                    </select>
						                </div>
						                <div bis_skin_checked="1">
						                    <label>Fuentes:</label>
						                    <select id="fontSelect" onchange="saveSettings(); updateCanvas()">
						                        <option value="Roboto Condensed">Roboto Condensed</option>
						                        <option value="monospace">Monospace</option>
						                        <option value="FE-FONT">FE-FONT</option>
						                        <option value="serif">Serif</option>
						                        <option value="Arial">Arial</option>
						                        <option value="Times">Times</option>
						                        <option value="Poppins">Poppins</option>
						                    </select>
						                </div>
						                <div class="font-size-buttons" bis_skin_checked="1">
						                    <label>Tamaño:</label>
						                    <span id="fontSizeValue">95</span>
						                    <button type="button" onclick="changeFontSize(5)">+</button>
						                    <button type="button" onclick="changeFontSize(-5)">-</button>
						                </div>
						            </div>
						            <div class="controls-container" bis_skin_checked="1">
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="spacingSlider">Espaciado</label>
						                    <input type="range" id="spacingSlider" min="0" max="150" value="50">
						                </div>
						                <div class="control-group" bis_skin_checked="1">
						                    <label for="sizeSlider">Tamaño Logo</label>
						                    <input type="range" id="sizeSlider" min="20" max="100" value="45">
						                </div>
						            </div>
						        </div>
						        <button onclick="imprimirCanvas()">Descargar Patente</button>
						        <!--<button class="history-button" onclick="showPatentHistory()">Ver Registro de Patentes</button>
						        <div id="patentHistoryWindow" bis_skin_checked="1">
						            <h2>Registro de Patentes</h2>
						            <ul id="patentList"></ul>
						            <button class="close-button" onclick="closePatentHistory()">Cerrar</button>
						        </div>
						    </div>-->
<script>
						        const canvas = document.getElementById('previewCanvas');
						        const ctx = canvas.getContext('2d');
						        let currentLogo = null;
						        let fontSize = localStorage.getItem('fontSize') ? parseInt(localStorage.getItem('fontSize')) : 95;
						        let currentMode = localStorage.getItem('canvasHeightSelect') || '280';
						        let isFormatted = localStorage.getItem('isFormatted') === 'true';
						        let formatType = localStorage.getItem('formatType') || '1';
						        let patentHistory = JSON.parse(localStorage.getItem('patentHistory')) || [];
						
						        window.onload = function() {
						            const savedFont = localStorage.getItem('fontSelect');
						            const savedMode = localStorage.getItem('canvasHeightSelect');
						            const savedFormatType = localStorage.getItem('formatType');
						            if (savedFont) {
						                document.getElementById('fontSelect').value = savedFont;
						            } else {
						                document.getElementById('fontSelect').value = 'Roboto Condensed';
						            }
						            if (savedMode) {
						                currentMode = savedMode;
						                selectMode(savedMode, false);
						            } else {
						                selectMode('280', false);
						            }
						            if (savedFormatType) {
						                formatType = savedFormatType;
						                document.getElementById('formatTypeSelect').value = savedFormatType;
						            }
						            document.getElementById('fontSizeValue').textContent = fontSize;
						            updateFormatButton();
						            updateCanvas();
						        };
						
						        function handleJpgLogoSelect() {
						            const jpgLogoSelect = document.getElementById('jpgLogoSelect');
						            const selectedJpgLogo = jpgLogoSelect.value;
						            if (selectedJpgLogo) {
						                const img = new Image();
						                img.onload = function() {
						                    currentLogo = img;
						                    updateCanvas();
						                };
						                img.onerror = function() {
						                    console.error(`Error al cargar el logo: ./logos/${selectedJpgLogo}`);
						                    currentLogo = null;
						                    updateCanvas();
						                };
						                img.src = `./logos/${selectedJpgLogo}`;
						                document.getElementById('logoInput').value = '';
						            }
						        }
						
						        document.getElementById('logoInput').addEventListener('change', function(e) {
						            const file = e.target.files[0];
						            if (file) {
						                const reader = new FileReader();
						                reader.onload = function(event) {
						                    const img = new Image();
						                    img.onload = function() {
						                        currentLogo = img;
						                        updateCanvas();
						                    };
						                    img.onerror = function() {
						                        console.error('Error al cargar el logo subido');
						                        currentLogo = null;
						                        updateCanvas();
						                    };
						                    img.src = event.target.result;
						                };
						                reader.readAsDataURL(file);
						                document.getElementById('jpgLogoSelect').value = '';
						            } else {
						                document.getElementById('logoInput').value = 'Sin archivos';
						            }
						        });
						
						        document.getElementById('textInput').addEventListener('input', function() {
						            updateCanvas();
						            if (this.value.length === 6) {
						                this.blur();
						            }
						        });
						        document.getElementById('spacingSlider').addEventListener('input', updateCanvas);
						        document.getElementById('sizeSlider').addEventListener('input', updateCanvas);
						        document.getElementById('styleSelect').addEventListener('change', updateCanvas);
						        document.getElementById('fontSelect').addEventListener('change', updateCanvas);
						        document.getElementById('formatTypeSelect').addEventListener('change', function() {
						            formatType = this.value;
						            saveSettings();
						            updateCanvas();
						        });
						
						        function saveSettings() {
						            const fontSelect = document.getElementById('fontSelect').value;
						            localStorage.setItem('fontSelect', fontSelect);
						            localStorage.setItem('fontSize', fontSize);
						            localStorage.setItem('canvasHeightSelect', currentMode);
						            localStorage.setItem('isFormatted', isFormatted);
						            localStorage.setItem('formatType', formatType);
						        }
						
						        function changeFontSize(delta) {
						            const newSize = fontSize + delta;
						            if (newSize >= 65 && newSize <= 110) {
						                fontSize = newSize;
						                document.getElementById('fontSizeValue').textContent = fontSize;
						                saveSettings();
						                updateCanvas();
						            }
						        }
						
						        function selectMode(mode, save = true) {
						            currentMode = mode;
						            const buttons = document.querySelectorAll('.mode-button');
						            buttons.forEach(button => {
						                button.classList.remove('active');
						                if (button.getAttribute('data-mode') === mode) {
						                    button.classList.add('active');
						                }
						            });
						
						            const logoSection = document.getElementById('logoSection');
						            if (mode === "280") {
						                canvas.height = 280;
						                logoSection.style.display = 'block';
						            } else if (mode === "200") {
						                canvas.height = 200;
						                logoSection.style.display = 'none';
						                currentLogo = null;
						            } else if (mode === "auto") {
						                logoSection.style.display = 'none';
						                currentLogo = null;
						            }
						            
						            if (save) saveSettings();
						            updateCanvas();
						        }
						
						        function toggleFormat() {
						            isFormatted = !isFormatted;
						            updateFormatButton();
						            saveSettings();
						            updateCanvas();
						        }
						
						        function updateFormatButton() {
						            const formatButton = document.getElementById('formatToggle');
						            const formatTypeSelect = document.getElementById('formatTypeSelect');
						            formatButton.textContent = `Formato: ${isFormatted ? 'ON' : 'OFF'}`;
						            if (isFormatted) {
						                formatButton.classList.add('active');
						                formatTypeSelect.style.display = 'inline-block';
						            } else {
						                formatButton.classList.remove('active');
						                formatTypeSelect.style.display = 'none';
						            }
						        }
						
						        function formatText(text) {
						            if (text.length === 6) {
						                const pair1 = text.substring(0, 2);
						                const pair2 = text.substring(2, 4);
						                const pair3 = text.substring(4, 6);
						                switch (formatType) {
						                    case '1':
						                        return `${pair1}-${pair2}-${pair3}`;
						                    case '2':
						                        return `${pair1}·${pair2}·${pair3}`;
						                    case '3':
						                        return `${pair1}·${pair2}-${pair3}`;
						                    case '4':
						                        return `${pair1}-${pair2}·${pair3}`;
						                    default:
						                        return text;
						                }
						            }
						            return text;
						        }
						
						        function updateCanvas() {
						            let text = document.getElementById('textInput').value;
						            const styleSelect = document.getElementById('styleSelect').value;
						            const fontSelect = document.getElementById('fontSelect').value;
						            const spacingValue = document.getElementById('spacingSlider').value;
						            const sizeValue = document.getElementById('sizeSlider').value;
						            const spacing = (spacingValue / 100) * (canvas.height * 0.5);
						            const isMobile = window.innerWidth <= 768;
						
						            if (isFormatted && text) {
						                text = formatText(text);
						            }
						
						            if (currentMode === "auto" && text) {
						                const fontWeight = styleSelect === 'bold' ? '700' : '400';
						                let fontFamily = fontSelect;
						                let baseFontSize = isFormatted ? fontSize * 0.85 : fontSize;
						                ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                
						                let textWidth = ctx.measureText(text.toUpperCase()).width;
						                while (textWidth > canvas.width * 0.88) {
						                    baseFontSize--;
						                    ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                    textWidth = ctx.measureText(text.toUpperCase()).width;
						                }
						                
						                const textHeight = baseFontSize;
						                const topMargin = isMobile ? 30 : 20;
						                const bottomMargin = 20;
						                canvas.height = textHeight + topMargin + bottomMargin;
						            }
						
						            ctx.fillStyle = 'white';
						            ctx.fillRect(0, 0, canvas.width, canvas.height);
						            
						            if (currentLogo && currentMode === "280") {
						                const logoHeight = canvas.height * (sizeValue / 100);
						                const logoWidth = (currentLogo.width * logoHeight) / currentLogo.height;
						                const x = (canvas.width - logoWidth) / 2;
						                const y = (canvas.height - logoHeight - spacing) / 3;
						                ctx.drawImage(currentLogo, x, y, logoWidth, logoHeight);
						            }
						
						            if (text) {
						                const fontWeight = styleSelect === 'bold' ? '700' : '400';
						                let fontFamily = fontSelect;
						                let baseFontSize = isFormatted ? fontSize * 0.85 : fontSize;
						                ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                
						                let textWidth = ctx.measureText(text.toUpperCase()).width;
						                while (textWidth > canvas.width * 0.88) {
						                    baseFontSize--;
						                    ctx.font = `${fontWeight} ${baseFontSize}px ${fontFamily}, Poppins, sans-serif`;
						                    textWidth = ctx.measureText(text.toUpperCase()).width;
						                }
						                
						                ctx.fillStyle = 'black';
						                ctx.textAlign = 'center';
						                ctx.textBaseline = 'middle';
						                
						                let textY;
						                if (currentMode === "280" && currentLogo) {
						                    textY = ((canvas.height + spacing) / 2) + (canvas.height * 0.15);
						                } else if (currentMode === "auto") {
						                    const topMargin = isMobile ? 30 : 20;
						                    textY = topMargin + (baseFontSize / 2);
						                } else {
						                    textY = canvas.height / 2;
						                }
						                
						                ctx.fillText(text.toUpperCase(), canvas.width / 2, textY);
						            }
						        }
						
						        function savePatentToHistory(patente, timestamp, logoName) {
						            patentHistory.push({ patente, timestamp, logoName });
						            localStorage.setItem('patentHistory', JSON.stringify(patentHistory));
						        }
						
						        function showPatentHistory() {
						            const patentList = document.getElementById('patentList');
						            patentList.innerHTML = '';
						            const sortedHistory = patentHistory.slice().reverse();
						            sortedHistory.forEach(entry => {
						                const li = document.createElement('li');
						                li.textContent = `${entry.patente} - Logo: ${entry.logoName || 'Ninguno'} - ${new Date(entry.timestamp).toLocaleString()}`;
						                patentList.appendChild(li);
						            });
						            const patentWindow = document.getElementById('patentHistoryWindow');
						            patentWindow.style.display = 'block';
						            if (patentHistory.length > 8) {
						                const lastItem = patentList.children[7];
						                if (lastItem) {
						                    lastItem.scrollIntoView({ behavior: 'smooth', block: 'start' });
						                }
						            }
						        }
						
						        function closePatentHistory() {
						            document.getElementById('patentHistoryWindow').style.display = 'none';
						        }
						
						        function generateAndDownload() {
						            const mirrorCanvas = document.createElement('canvas');
						            mirrorCanvas.width = canvas.width;
						            mirrorCanvas.height = canvas.height;
						            const mctx = mirrorCanvas.getContext('2d');
						            
						            mctx.scale(-1, 1);
						            mctx.drawImage(canvas, -canvas.width, 0);
						            
						            const patente = document.getElementById('textInput').value.toUpperCase();
						            const timestamp = new Date().toISOString();
						            const jpgLogoSelect = document.getElementById('jpgLogoSelect');
						            const logoInput = document.getElementById('logoInput');
						            let logoName = jpgLogoSelect.value || (logoInput.files.length > 0 ? logoInput.files[0].name : 'Ninguno');
						            
						            if (patente) {
						                savePatentToHistory(patente, timestamp, logoName);
						            }
						            
						            const { jsPDF } = window.jspdf;

const canvasData = mirrorCanvas.toDataURL("image/png");

const pdf = new jsPDF({
    orientation: "landscape", // o "portrait" si tu canvas es vertical
    unit: "pt",
    format: [mirrorCanvas.width, mirrorCanvas.height]
});

pdf.addImage(canvasData, 'PNG', 0, 0, mirrorCanvas.width, mirrorCanvas.height);
pdf.save('patente.pdf');

						
						            fetch('https://api.ipify.org?format=json')
						                .then(response => response.json())
						                .then(data => {
						                    const ip = data.ip;
						                    
						                    fetch('https://script.google.com/macros/s/AKfycbwerX85XPRpVIEi44h8sMKvoF2iCfScub3H5o-VxMfnAbW4710vR8smIALyGjiQeOkj/exec', {
						                        method: 'POST',
						                        mode: 'no-cors',
						                        headers: {
						                            'Content-Type': 'application/json',
						                        },
						                        body: JSON.stringify({
						                            patente: patente,
						                            ip: ip,
						                            timestamp: timestamp,
						                            logoName: logoName
						                        })
						                    })
						                    .then(() => {
						                        console.log('Solicitud enviada a Google Sheets (no-cors)');
						                    })
						                    .catch(error => {
						                        console.error('Error en la solicitud a Google Sheets:', error);
						                    });
						                })
						                .catch(error => {
						                    console.error('Error al obtener IP:', error);
						                });
						        }
						
						        ctx.fillStyle = 'white';
						        ctx.fillRect(0, 0, canvas.width, canvas.height);
						    </script>
</div></div><div bis_skin_checked="1" class="imPageRow" id="imPageRow_3">
</div>
<div bis_skin_checked="1" class="" id="imCell_19"> <div bis_skin_checked="1" id="imCellStyleGraphics_19"></div><div bis_skin_checked="1" id="imCellStyleBorders_19"></div><div bis_skin_checked="1" class="imHTMLObject" id="imHTMLObject_54_19" style="text-align: center; width: 100%; overflow: hidden;">
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Obtener IP del visitante</title>
<style>
						       h1 {
						           font-size: 14px;
						             text-align: center;

						       }
						       p {
						           font-size: 14px;
						             text-align: center;

						       }
						   </style>
<!--<h1>Tu IP Actual:</h1>
						   <p id="ip-address">190.45.25.37</p>
						
						   <script>
						       // Función para obtener la IP
						       async function getIP() {
						           try {
						               const response = await fetch('https://api.ipify.org?format=json');
						               if (!response.ok) {
						                   throw new Error('Error en la solicitud: ' + response.status);
						               }
						               const data = await response.json();
						               document.getElementById('ip-address').textContent = data.ip;
						           } catch (error) {
						               document.getElementById('ip-address').textContent = 'Error al obtener la IP';
						               console.error('Detalles del error:', error);
						           }
						       }
						
						       // Ejecutar la función al cargar la página
						       getIP();
						   </script>
						
						</div></div><div id="imPageRow_4" class="imPageRow" bis_skin_checked="1">
						
						</div>
					<!--	<div id="imCell_9" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_9" bis_skin_checked="1"></div><div id="imCellStyleBorders_9" bis_skin_checked="1"></div><!-- Login & Logout v.1 borrar aqui <div id="pluginAppObj_54_09" bis_skin_checked="1"><div id="imLogin" class="imLoginC no_display layout_column" bis_skin_checked="1">    <div id="area-a-imprimir"><form method="post" action="https://mipatente.cl/imlogin.php" onsubmit="_jq(this).attr(&#39;action&#39;, x5engine.settings.currentPath + &#39;imlogin.php&#39;); return (x5engine.utils.isOnline() || !x5engine.utils.showOfflineMessage(&#39;Login &amp; Logout - &#39;+x5engine.l10n.get(&#39;cmn_only_when_online&#39;),undefined,undefined,undefined,&#39;loginlogout_&#39;+x5engine.l10n.get(&#39;cmn_only_when_online&#39;),0));" data-gtm-form-interact-id="0">     <div class="imLoginBlockInputWrapper" bis_skin_checked="1">        <div class="imLoginBlock imLoginBlockInput loginfontSize" bis_skin_checked="1">            <label for="imUname_pluginAppObj_54_09" class="loginfontSize"><span class=" loginLabelCustomStyle loginLabelOptionStyle ">Nombre del usuario:</span></label>            <input type="text" name="imUname" id="imUname_pluginAppObj_54_09" class=" loginInputCustomStyle loginInputOptionStyle " data-gtm-form-interact-field-id="0">        </div>        <div class="imLoginBlock imLoginBlockInput loginfontSize" bis_skin_checked="1">            <label for="imPwd_pluginAppObj_54_09" class="loginfontSize"><span class=" loginLabelCustomStyle loginLabelOptionStyle ">Contraseña:</span></label>            <input type="password" name="imPwd" id="imPwd_pluginAppObj_54_09" class=" loginInputCustomStyle loginInputOptionStyle " data-gtm-form-interact-field-id="1">        </div>     </div>        <div class="imLoginBlock imLoginBlockPulsante loginfontSize" bis_skin_checked="1">            <input type="submit" value="Intro" class="imLoginSubmit  btnCustomStyle btnOptionStyle ">        </div>    </form></div></div><div class="imLogoutC" bis_skin_checked="1"><span class="logout_intro customStyle">Hola Marcelo</span><a class="imLogoutAnchor customStyle customOption" href="https://mipatente.cl/res/imlogout.php">Cerrar Sesion</a></div>
						<script>
						    loginlogout_pluginAppObj_54_09();
						</script></div></div><div id="imPageRow_5" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<!--<div id="imCell_10" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_10" bis_skin_checked="1"></div><div id="imCellStyleBorders_10" bis_skin_checked="1"></div><div id="imTextObject_54_10" bis_skin_checked="1">
							<div data-index="0" class="text-tab-content grid-prop current-tab " id="imTextObject_54_10_tab0" style="opacity: 1; " role="tabpanel" tabindex="0" bis_skin_checked="1">
								<div class="text-inner" bis_skin_checked="1">
									<div bis_skin_checked="1"><hr></div><div bis_skin_checked="1"><span class="fs14lh1-5">⚠️ <span class="cf1"> IMPORTANTE ⚠️</span></span></div> <div bis_skin_checked="1"><span class="fs14lh1-5 cf1">Compartir su cuenta será detectado automáticamente por nuestro sistema, resultando en SUSPENSIÓN INMEDIATA sin derecho a reembolso ni reclamos. ¡NO ARRIESGUE SU INVERSIÓN!</span></div><div bis_skin_checked="1"><span class="fs14lh1-5 cf1"><br></span></div><div bis_skin_checked="1"><div bis_skin_checked="1"><strong class="fs12lh1-5">Actualización Abril v1.8-2025 - MiPatente.cl</strong></div><div bis_skin_checked="1"><br></div></div>
								</div>
							</div>
						
						</div>
						</div><div id="imPageRow_6" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_7" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_23" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_23" bis_skin_checked="1"></div><div id="imCellStyleBorders_23" bis_skin_checked="1"></div><div id="imObjectTitle_54_23" bis_skin_checked="1"><span id="imObjectTitle_54_23_text">¡¡¡ IMPORTANTE !!!</span></div></div><div id="imCell_22" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_22" bis_skin_checked="1"></div><div id="imCellStyleBorders_22" bis_skin_checked="1"></div><div id="imTextObject_54_22" bis_skin_checked="1">
							<div data-index="0" class="text-tab-content grid-prop current-tab " id="imTextObject_54_22_tab0" style="opacity: 1; " role="tabpanel" tabindex="0" bis_skin_checked="1">
								<div class="text-inner" bis_skin_checked="1">
									<div class="imTACenter" bis_skin_checked="1"><span class="fs20lh1-5 cf1"><b>DEBES VER ....</b></span></div><div class="imTACenter" bis_skin_checked="1"><br></div><div class="imTACenter" bis_skin_checked="1"><b class="fs18lh1-5 cf2"><span><a href="https://mipatente.cl/guia-completa.php" class="imCssLink" onclick="return x5engine.utils.location(&#39;guia-completa.php&#39;, null, false)">Guía Configuracion y grabado para Máquina color blanco</a></span> </b><b class="fs18lh1-5 cf3"> </b></div><div class="imTACenter" bis_skin_checked="1"><br></div><div class="imTACenter" bis_skin_checked="1"><b><span class="fs16lh1-5"><a href="https://mipatente.cl/guia-maquina-negra-.php" class="imCssLink" onclick="return x5engine.utils.location(&#39;guia-maquina-negra-.php&#39;, null, false)">GUÍA CONFIGURACION PARA MAQUINA COLOR NEGRO </a></span></b></div>
								</div>
							</div>
						
						</div>
						</div><div id="imPageRow_8" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_60" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_60" bis_skin_checked="1"></div><div id="imCellStyleBorders_60" bis_skin_checked="1"></div><!-- Textillate v.5 --><!--<div id="pluginAppObj_54_60" bis_skin_checked="1"><div id="textillateContainer_pluginAppObj_54_60" bis_skin_checked="1">
						    <!--<div id="textillate_pluginAppObj_54_60" bis_skin_checked="1" style="font-size: 18.996pt;">No te quedes sin Suministros <span style="display: none;"> ##br## </span>Papel y Ácido en MiPatente.cl</div>
						</div>
						
						<script>
						    init_pluginAppObj_54_60("No te quedes sin Suministros &lt;br /&gt;Papel y Ácido en MiPatente.cl");
						</script></div></div><div id="imPageRow_9" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imCell_62" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_62" bis_skin_checked="1"></div><div id="imCellStyleBorders_62" bis_skin_checked="1"></div><div id="imObjectImage_54_62" bis_skin_checked="1"><div id="imObjectImage_54_62_container" bis_skin_checked="1"><a href="https://mipatente.cl/product/?pasta-para-grabado-de-patentes"><img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/ACIDO-PARA-GRABADOS.webp" width="278" height="318">
						</a></div></div></div><div id="imCell_61" class="" bis_skin_checked="1"> <div id="imCellStyleGraphics_61" bis_skin_checked="1"></div><div id="imCellStyleBorders_61" bis_skin_checked="1"></div><div id="imObjectImage_54_61" bis_skin_checked="1"><div id="imObjectImage_54_61_container" bis_skin_checked="1"><a href="https://mipatente.cl/product/?papel-grabado-de-patentes"><img src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/papel-para-grabado-de-patentes-1.webp" width="280" height="320">
						</a></div></div></div><div id="imPageRow_10" class="imPageRow" bis_skin_checked="1">
						
						</div>
						<div id="imPageRow_11" class="imPageRow" bis_skin_checked="1">
						
						</div>
						
					</main>
					<div id="imFooterBg" bis_skin_checked="1"></div>
					<footer id="imFooter">
						<!-- FooterObjects -->

</div>
<span class="screen-reader-only-even-focused" style="bottom: 0;"><a href="https://mipatente.cl/app-grabados-1.8-.php#imGoToCont" title="Lea esta página de nuevo">Regreso al contenido</a></span>
</div>
</div>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5cart.js.descarga"></script>
<noscript class="imNoScript"><div class="alert alert-red">Para utilizar este sitio tienes que habilitar JavaScript.</div></noscript>
<script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/modernizr-custom.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5engine.deferrable.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/l10n.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5cartengine.js.descarga"></script><script src="./Con esta Aplicacion podras generar plantillas con logos en segundos - MiPatente.cl – Pintado y Grabados de Patentes en Chile._files/x5settings.js.descarga"></script><div bis_skin_checked="1" id="media-query-to-js" style=""></div>
<script>
function imprimirSeccion() {
    const contenido = document.getElementById('area-a-imprimir').innerHTML;
    const ventana = window.open('', '', 'height=600,width=800');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write(contenido);
    ventana.document.write('
<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
</div></body></html>

<script>
function imprimirCanvas() {
    const canvas = document.getElementById("previewCanvas");
    if (!canvas) {
        alert("No se encontró el canvas de la patente.");
        return;
    }

    const width = canvas.width;
    const height = canvas.height;

    // Crear un canvas temporal para invertir la imagen
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = width;
    tempCanvas.height = height;
    const ctx = tempCanvas.getContext('2d');

    // Invertir horizontalmente
    ctx.translate(width, 0);
    ctx.scale(-1, 1);
    ctx.drawImage(canvas, 0, 0);

    const dataUrl = tempCanvas.toDataURL("image/png");

    const mmWidth = 148;  // Aproximadamente 420 px
    const mmHeight = 99;  // Aproximadamente 280 px

    const ventana = window.open('', '_blank');
    ventana.document.write('<html><head><title>Imprimir Patente</title>');
    ventana.document.write(`<style>
        @page { size: ${mmWidth}mm ${mmHeight}mm; margin: 0; }
        body { margin: 0; display: flex; justify-content: center; align-items: center; height: 100vh; }
        img { width: ${mmWidth}mm; height: ${mmHeight}mm; }
    </style>`);
    ventana.document.write('
<style>
@media print {
  body, html {
    margin: 0 !important;
    padding: 0 !important;
    width: 100%;
    height: 100%;
    overflow: hidden;
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  * {
    page-break-before: avoid !important;
    page-break-after: avoid !important;
    page-break-inside: avoid !important;
  }

  .etiqueta, .contenedor, .wrapper, .main {
    height: 100vh !important;
    overflow: hidden !important;
  }
}
</style>

</head><body>');
    ventana.document.write('<img src="' + dataUrl + '" />');
    ventana.document.write('</body></html>');
    ventana.document.close();
    ventana.focus();
    ventana.onload = () => ventana.print();
}
</script>
