
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generador de Patente</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #1d2d44;
            color: #fff;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 20px;
        }
        canvas {
            background: #fff;
            border: 4px solid #00c897;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            margin-bottom: 20px;
        }
        button {
            background: #00c897;
            color: #fff;
            border: none;
            padding: 10px 20px;
            font-size: 1rem;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover {
            background: #f48c06;
        }
        input {
            padding: 10px;
            font-size: 1.2rem;
            text-align: center;
            border-radius: 6px;
            border: none;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <h1>Generador de Patente</h1>
    <input type="text" id="textInput" placeholder="Ingresa patente" maxlength="6" style="text-transform: uppercase;">
    <canvas id="previewCanvas" width="420" height="280"></canvas>
    <button onclick="descargarPNG()">Descargar PNG</button>

    <script>
        const canvas = document.getElementById('previewCanvas');
        const ctx = canvas.getContext('2d');

        function dibujarCanvas() {
            const text = document.getElementById('textInput').value.toUpperCase();

            ctx.fillStyle = 'white';
            ctx.fillRect(0, 0, canvas.width, canvas.height);

            ctx.fillStyle = 'black';
            ctx.font = 'bold 80px Arial';
            ctx.textAlign = 'center';
            ctx.textBaseline = 'middle';
            ctx.fillText(text, canvas.width / 2, canvas.height / 2);
        }

        document.getElementById('textInput').addEventListener('input', dibujarCanvas);

        function descargarPNG() {
            const dataUrl = canvas.toDataURL('image/png');
            const link = document.createElement('a');
            link.href = dataUrl;
            link.download = 'patente.png';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        dibujarCanvas();
    </script>

</body>
</html>
