
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Patente 4.3cm x 1cm Fija</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f4f4f4;
        }
        .container {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            max-width: 400px;
            margin: auto;
        }
        canvas {
            display: block;
            margin: 10px auto;
            border: 1px solid #ccc;
        }
        input, button {
            width: 100%;
            padding: 10px;
            font-size: 18px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<div class="container">
    <h3>Patente 4.3cm x 1cm</h3>
    <input type="text" id="textInput" maxlength="6" placeholder="ABC123" oninput="updateCanvas()" style="text-transform: uppercase;">
    <canvas id="previewCanvas" width="1000" height="230"></canvas>
    <button onclick="imprimirPatente()">Imprimir Patente</button>
</div>

<script>
const canvas = document.getElementById('previewCanvas');
const ctx = canvas.getContext('2d');

function updateCanvas() {
    const text = document.getElementById('textInput').value.toUpperCase();
    ctx.fillStyle = 'white';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = 'black';
    ctx.font = '200px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(text, canvas.width / 2, canvas.height / 2);
}

function imprimirPatente() {
    const tempCanvas = document.createElement('canvas');
    tempCanvas.width = 1000;
    tempCanvas.height = 230;
    const tctx = tempCanvas.getContext('2d');

    tctx.fillStyle = 'white';
    tctx.fillRect(0, 0, tempCanvas.width, tempCanvas.height);
    tctx.fillStyle = 'black';
    tctx.translate(tempCanvas.width, 0);
    tctx.scale(-1, 1);
    tctx.font = '200px Arial';
    tctx.textAlign = 'center';
    tctx.textBaseline = 'middle';
    tctx.fillText(document.getElementById('textInput').value.toUpperCase(), tempCanvas.width / 2, tempCanvas.height / 2);

    const dataUrl = tempCanvas.toDataURL('image/png');
    const w = window.open('', '_blank');
    w.document.write('<html><head><title>Imprimir</title><style>body{margin:0;} img{width:4.3cm;height:1cm;display:block;margin:auto;}</style></head><body>');
    w.document.write('<img src="' + dataUrl + '"/>');
    w.document.write('</body></html>');
    w.document.close();
    w.focus();
    w.onload = () => w.print();
}

updateCanvas();
</script>
</body>
</html>
