
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Patente 50mm x 20mm</title>
</head>
<body>
    <canvas id="previewCanvas" width="420" height="280" style="display:none;"></canvas>
    <script>
    // Para pruebas, dibuja algo en el canvas
    const canvas = document.getElementById("previewCanvas");
    const ctx = canvas.getContext("2d");
    ctx.fillStyle = "white";
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = "black";
    ctx.font = "90px Arial";
    ctx.textAlign = "center";
    ctx.textBaseline = "middle";
    ctx.fillText("AB-CD-12", canvas.width / 2, canvas.height / 2);

    function imprimirPatenteTamañoReal() {
        const tempCanvas = document.createElement('canvas');
        tempCanvas.width = 197; // aprox 50mm a 100 dpi
        tempCanvas.height = 79; // aprox 20mm
        const ctxTemp = tempCanvas.getContext('2d');

        ctxTemp.fillStyle = "white";
        ctxTemp.fillRect(0, 0, tempCanvas.width, tempCanvas.height);

        ctxTemp.translate(tempCanvas.width, 0);
        ctxTemp.scale(-1, 1);
        ctxTemp.drawImage(canvas, 0, 0, tempCanvas.width, tempCanvas.height);

        const dataUrl = tempCanvas.toDataURL("image/png");

        const win = window.open('', '_blank');
        win.document.write('<html><head><title>Imprimir Patente</title>');
        win.document.write('<style>body {margin:0;text-align:center;} img {display:block;margin:auto;width:50mm;height:20mm;}</style>');
        win.document.write('</head><body>');
        win.document.write('<img src="' + dataUrl + '" />');
        win.document.write('</body></html>');
        win.document.close();
        win.focus();
        win.onload = () => win.print();
    }

    // Llamar automáticamente para prueba
    imprimirPatenteTamañoReal();
    </script>
</body>
</html>
